/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.blender;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.Config;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.MessageVortexRepository;
import net.messagevortex.Version;
import net.messagevortex.accounting.Accountant;
import net.messagevortex.asn1.BlendingSpec;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.asn1.IdentityStoreBlock;
import net.messagevortex.asn1.InnerMessageBlock;
import net.messagevortex.asn1.PrefixBlock;
import net.messagevortex.asn1.RoutingCombo;
import net.messagevortex.asn1.VortexMessage;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.blender.Blender;
import net.messagevortex.blender.BlendingReceiver;
import net.messagevortex.blender.recipes.BlenderRecipe;
import net.messagevortex.transport.Transport;
import net.messagevortex.transport.dummy.DummyTransportTrx;

public class InitialRecipesBlender
extends Blender {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final String identity;
    private final Transport transport;
    private final BlendingReceiver router;
    private IdentityStore identityStore;
    private int anonSetSize = 5;

    public InitialRecipesBlender(String section) throws IOException {
        this(Config.getDefault().isDefaultValue(section, "node_identity") ? null : Config.getDefault().getStringValue(section, "node_identity"), MessageVortexRepository.getRouter("", Config.getDefault().getSectionValue(section, "router")), MessageVortexRepository.getIdentityStore("", Config.getDefault().getSectionValue(section, "identity_store")), MessageVortexRepository.getAccountant("", Config.getDefault().getSectionValue(section, "accountant")));
    }

    public InitialRecipesBlender(String identity, BlendingReceiver router, IdentityStore identityStore, Accountant acc) throws IOException {
        super(router, acc);
        this.identityStore = identityStore;
        this.identity = identity;
        this.transport = identity != null ? new DummyTransportTrx(identity, this) : null;
        this.router = router;
        if (identityStore == null) {
            throw new NullPointerException("identitystore may not be null");
        }
        this.identityStore = identityStore;
    }

    public int setAnonymitySetSize(int newSize) {
        int oldsetsize = this.anonSetSize;
        this.anonSetSize = newSize;
        return oldsetsize;
    }

    @Override
    public String getBlendingAddress() {
        return this.identity;
    }

    @Override
    public byte[] blendMessageToBytes(BlendingSpec target, VortexMessage msg) {
        return new byte[0];
    }

    @Override
    public VortexMessage unblendMessage(byte[] blendedMessage) {
        return null;
    }

    @Override
    public boolean blendMessage(BlendingSpec target, VortexMessage msg) {
        try {
            Authenticator a = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("username", "password");
                }
            };
            Session session = Session.getInstance((Properties)new Properties(), (Authenticator)a);
            final MimeMessage mimeMsg = new MimeMessage(session);
            mimeMsg.setFrom((Address)new InternetAddress("test@test.com"));
            mimeMsg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(target.getRecipientAddress()));
            mimeMsg.setSubject("VortexMessage");
            mimeMsg.setHeader("User-Agent:", "MessageVortex/" + Version.getStringVersion());
            MimeMultipart content = new MimeMultipart("mixed");
            MimeBodyPart body = new MimeBodyPart();
            body.setText("This is a VortexMessage");
            content.addBodyPart((BodyPart)body);
            MimeBodyPart attachment = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(msg.toBytes(DumpType.PUBLIC_ONLY), "application/octet-stream");
            attachment.setDataHandler(new DataHandler((DataSource)source));
            attachment.setFileName("messageVortex.raw");
            content.addBodyPart((BodyPart)attachment);
            mimeMsg.setContent((Multipart)content);
            final PipedOutputStream os = new PipedOutputStream();
            new Thread(){

                @Override
                public void run() {
                    try {
                        mimeMsg.writeTo((OutputStream)os);
                        os.close();
                    }
                    catch (MessagingException | IOException ioe) {
                        LOGGER.log(Level.WARNING, "Error while sending message", ioe);
                    }
                }
            }.start();
            PipedInputStream inp = new PipedInputStream(os);
            this.transport.sendMessage(target.getRecipientAddress(), inp);
            return true;
        }
        catch (AddressException ae) {
            LOGGER.log(Level.SEVERE, "Error when setting address", ae);
        }
        catch (MessagingException me) {
            LOGGER.log(Level.SEVERE, "Error when composing message", me);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Unable to send to transport endpoint " + target.getRecipientAddress(), ioe);
        }
        return false;
    }

    @Override
    public boolean gotMessage(InputStream is) {
        try {
            Authenticator a = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("username", "password");
                }
            };
            Session session = Session.getInstance((Properties)new Properties(), (Authenticator)a);
            int i = 0;
            MimeMessage msg = new MimeMessage(session, is);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)os);
            os.close();
            byte[] barr = os.toByteArray();
            Address[] from = msg.getFrom();
            Address[] to = msg.getAllRecipients();
            LOGGER.log(Level.INFO, "Got a message to blend from " + String.valueOf(from[0]) + " to " + String.valueOf(to[0]));
            IdentityStore istore = this.identityStore;
            Set<IdentityStoreBlock> anonSet = istore.getAnonSet(this.anonSetSize);
            if (anonSet == null) {
                LOGGER.log(Level.WARNING, "unable to get anonymity set for message");
                return false;
            }
            BlenderRecipe recipe = BlenderRecipe.getRecipe(null, anonSet);
            if (recipe == null) {
                LOGGER.log(Level.WARNING, "unable to get recipe for message");
                return false;
            }
            LOGGER.log(Level.INFO, "blending messages");
            for (Address receiverAddress : to) {
                LOGGER.log(Level.INFO, "blending message for \"" + String.valueOf(receiverAddress) + "\"");
                IdentityStoreBlock fromAddr = istore.getIdentity(from[0].toString());
                IdentityStoreBlock toAddr = istore.getIdentity(receiverAddress.toString());
                RoutingCombo rb = recipe.applyRecipe(anonSet, fromAddr, toAddr);
                if (rb == null) {
                    LOGGER.log(Level.WARNING, "Unable to route message to " + String.valueOf(receiverAddress));
                }
                PrefixBlock pb = new PrefixBlock();
                InnerMessageBlock im = new InnerMessageBlock();
                im.setRouting(rb);
                im.setPayload(0, barr);
                VortexMessage vmsg = new VortexMessage(pb, im);
                if (!this.router.gotMessage(vmsg)) continue;
                ++i;
            }
            LOGGER.log(Level.INFO, "done blending");
            return i == to.length;
        }
        catch (MessagingException | IOException ioe) {
            LOGGER.log(Level.WARNING, "Exception while getting and parsing message", ioe);
            return false;
        }
    }
}

