/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.asn1.encryption.DumpType;
import picocli.CommandLine;

@CommandLine.Command(description={"remove an identity and dump store"}, name="removeIdentity", aliases={"remove", "rem", "del"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerIdentityStoreDel
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"--filename", "-f"}, description={"filename of the IdentityStorage file"})
    String filename = "identityStore.cfg";
    @CommandLine.Option(names={"--nodeAddress"}, required=true, description={"the identity address"})
    String[] nodeAddress;

    @Override
    public Integer call() throws Exception {
        if (!new File(this.filename).exists()) {
            LOGGER.log(Level.SEVERE, "File \"" + this.filename + "\" not found");
            return 103;
        }
        LOGGER.log(Level.INFO, "Loading identity store \"" + this.filename + "\"");
        IdentityStore is = new IdentityStore(new File(this.filename));
        for (String v : this.nodeAddress) {
            LOGGER.log(Level.INFO, "Removing \"" + v + "\"");
            try {
                is.removeAddress(v);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "unable to remove \"" + v + "\"");
                return 101;
            }
        }
        LOGGER.log(Level.INFO, "Dumping identity store");
        System.out.println(is.dumpValueNotation("", DumpType.ALL_UNENCRYPTED));
        LOGGER.log(Level.INFO, "writing identity store to \"" + this.filename + "\"");
        try (OutputStream os = Files.newOutputStream(Paths.get(this.filename, new String[0]), new OpenOption[0]);){
            os.write(is.toBytes(DumpType.ALL_UNENCRYPTED));
        }
        LOGGER.log(Level.INFO, "finished");
        return 0;
    }
}

