/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.messagevortex.transport.imap.ImapCommand;
import net.messagevortex.transport.imap.ImapCommandAuthenticate;
import net.messagevortex.transport.imap.ImapCommandCapability;
import net.messagevortex.transport.imap.ImapCommandLogin;
import net.messagevortex.transport.imap.ImapCommandLogout;
import net.messagevortex.transport.imap.ImapCommandNoop;

public class ImapCommandFactory {
    private static final Map<String, ImapCommand> COMMANDS = new ConcurrentHashMap<String, ImapCommand>();

    public static void registerCommand(ImapCommand command) {
        String[] arr;
        for (String a : arr = command.getCommandIdentifier()) {
            COMMANDS.put(a.toLowerCase(), command);
        }
    }

    public static void deregisterCommand(String command) {
        COMMANDS.remove(command.toLowerCase());
    }

    public static ImapCommand[] getCommands() {
        return COMMANDS.values().toArray(new ImapCommand[0]);
    }

    public static ImapCommand getCommand(String name) {
        return COMMANDS.get(name.toLowerCase());
    }

    static {
        ImapCommandFactory.registerCommand(new ImapCommandCapability());
        ImapCommandFactory.registerCommand(new ImapCommandLogin());
        ImapCommandFactory.registerCommand(new ImapCommandAuthenticate());
        ImapCommandFactory.registerCommand(new ImapCommandLogout());
        ImapCommandFactory.registerCommand(new ImapCommandNoop());
    }
}

