/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.smtp;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.AbstractDaemon;
import net.messagevortex.Config;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.MessageVortexRepository;
import net.messagevortex.transport.Transport;
import net.messagevortex.transport.TransportReceiver;

public class TestSmtpHandler
extends AbstractDaemon
implements Transport,
Runnable {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final GreenMail server;
    private final String section;
    private final Thread mailHandler = new Thread(this);
    private final TransportReceiver blender;
    private final Object runningLock = new Object();
    private boolean isRunning = false;

    public TestSmtpHandler(String section) throws IOException {
        Config cfg = Config.getDefault();
        this.blender = MessageVortexRepository.getBlender("", cfg.getStringValue(section, "blender"));
        if (this.blender == null) {
            throw new IOException("unable to fetch apropriate blender (" + cfg.getStringValue(section, "blender") + " from section " + section + ")");
        }
        ServerSetup setup = new ServerSetup(cfg.getNumericValue(section, "smtp_incoming_port"), cfg.getStringValue(section, "smtp_incoming_address"), "smtp");
        setup.setVerbose(true);
        setup.setServerStartupTimeout(50000L);
        this.server = new GreenMail(new ServerSetup[]{setup});
        String username = cfg.getStringValue(section, "smtp_incoming_user");
        String password = cfg.getStringValue(section, "smtp_incoming_password");
        if (username == null || "".equals(username)) {
            throw new IOException("username for incoming smtp may not be null");
        }
        if (password == null || "".equals(password)) {
            throw new IOException("password for incoming smtp may not be null");
        }
        this.server.setUser(username, password);
        this.section = section;
        this.startDaemon();
    }

    @Override
    public void run() {
        int count = 1;
        while (this.isRunning) {
            boolean gotMail = this.server.waitForIncomingEmail(1000L, count);
            if (!gotMail) continue;
            String msg = GreenMailUtil.getWholeMessage((Part)this.server.getReceivedMessages()[count - 1]);
            LOGGER.log(Level.INFO, "got smtp mail in transport handler [" + this.section + "] (size:" + msg.length() + ")");
            this.blender.gotMessage(new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8)));
            ++count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startDaemon() {
        Object object = this.runningLock;
        synchronized (object) {
            this.isRunning = true;
            this.server.start();
            this.mailHandler.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownDaemon() {
        Object object = this.runningLock;
        synchronized (object) {
            this.isRunning = false;
            this.server.stop();
        }
        while (this.mailHandler.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void sendMessage(String address, InputStream os) throws IOException {
        try {
            final String username = Config.getDefault().getStringValue(this.section, "smtp_outgoing_user");
            final String password = Config.getDefault().getStringValue(this.section, "smtp_outgoing_password");
            Properties props = new Properties();
            props.put("mail.smtp.auth", username != null && !"".equals(username) ? "true" : "false");
            props.put("mail.smtp.starttls.enable", Config.getDefault().getBooleanValue(this.section, "smtp_outgoing_starttls") ? "true" : "false");
            props.put("mail.smtp.host", Config.getDefault().getStringValue(this.section, "smtp_outgoing_address"));
            props.put("mail.smtp.port", "" + Config.getDefault().getNumericValue(this.section, "smtp_outgoing_port"));
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
            MimeMessage msg = new MimeMessage(session, os);
            jakarta.mail.Transport.send((Message)msg);
        }
        catch (MessagingException me) {
            throw new IOException("exception while creating MimeMessage", me);
        }
    }
}

