/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import net.messagevortex.asn1.IdentityStoreBlock;
import net.messagevortex.asn1.RoutingCombo;
import net.messagevortex.router.Edge;

public class GraphSet
implements Comparator<GraphSet>,
Comparable<GraphSet>,
Iterable<Edge> {
    private static final long serialVersionUID = 16134223345689L;
    private final List<Edge> store = new ArrayList<Edge>();
    private List<IdentityStoreBlock> anonymitySet;
    private IdentityStoreBlock source = null;
    private IdentityStoreBlock target = null;
    private boolean hasChanged = true;
    private final Object cacheLock = new Object();
    private GraphSet[] cache = null;

    public GraphSet() {
        this.anonymitySet = new Vector<IdentityStoreBlock>();
    }

    public IdentityStoreBlock[] getAnonymitySet() {
        return this.anonymitySet.toArray(new IdentityStoreBlock[this.anonymitySet.size()]);
    }

    public void setAnonymitySet(IdentityStoreBlock[] anonymitySet) {
        ArrayList<IdentityStoreBlock> tmp = new ArrayList<IdentityStoreBlock>();
        tmp.addAll(Arrays.asList(anonymitySet));
        this.anonymitySet = tmp;
    }

    public IdentityStoreBlock getAnonymity(int i) {
        return this.anonymitySet.get(i);
    }

    public IdentityStoreBlock getSource() {
        return this.source;
    }

    public void setSource(IdentityStoreBlock source) {
        if (source == null) {
            throw new NullPointerException("source may not be null");
        }
        if (!this.anonymitySet.contains(source)) {
            throw new IllegalArgumentException("source must be member of anonymity set");
        }
        this.hasChanged = true;
        this.source = source;
    }

    public IdentityStoreBlock getTarget() {
        return this.target;
    }

    public void setTarget(IdentityStoreBlock target) {
        if (target == null) {
            throw new NullPointerException("target may not be null");
        }
        if (!this.anonymitySet.contains(target)) {
            throw new IllegalArgumentException("target must be member of anonymity set");
        }
        this.hasChanged = true;
        this.target = target;
    }

    public int getAnonymitySetSize() {
        return this.anonymitySet.size();
    }

    public int getAnonymityIndex(IdentityStoreBlock isb) {
        return this.anonymitySet.indexOf(isb);
    }

    public boolean add(Edge g) {
        this.hasChanged = true;
        return this.store.add(g);
    }

    public boolean contains(Edge g) {
        for (Edge e : this.store) {
            if (!e.equals(g)) continue;
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<? extends Edge> g) {
        this.hasChanged = true;
        return this.store.addAll(g);
    }

    public IdentityStoreBlock getAnonIdentity(int i) {
        if (i < 0 || i >= this.anonymitySet.size()) {
            throw new ArrayIndexOutOfBoundsException("got invalid identity vector (" + i + ")");
        }
        return this.anonymitySet.get(i);
    }

    public boolean allTargetsReached() {
        for (IdentityStoreBlock is : this.anonymitySet) {
            if (this.targetReached(is)) continue;
            return false;
        }
        return true;
    }

    public boolean targetReached(IdentityStoreBlock is) {
        if (is == null) {
            throw new NullPointerException();
        }
        if (is.equals(this.source)) {
            return true;
        }
        for (Edge g : this.store) {
            if (g.getTo() != is) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphSet[] getRoutes() {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.hasChanged) {
                TreeSet<GraphSet> ret = new TreeSet<GraphSet>();
                for (int i = 0; i < this.store.size(); ++i) {
                    Edge[][] g;
                    if (!this.store.get(i).getFrom().equals(this.getSource())) continue;
                    for (Edge[] gr : g = this.getRoute(i, new Edge[]{this.store.get(i)}, this.getTarget())) {
                        GraphSet gs = new GraphSet();
                        gs.setAnonymitySet(this.getAnonymitySet());
                        gs.setSource(this.getSource());
                        gs.setTarget(this.getTarget());
                        gs.add(this.store.get(i));
                        gs.addAll(Arrays.asList(gr));
                        ret.add(gs);
                    }
                }
                this.hasChanged = false;
                this.cache = ret.toArray(new GraphSet[ret.size()]);
            }
            return this.cache;
        }
    }

    private Edge[][] getRoute(int startIndex, Edge[] visited, IdentityStoreBlock to) {
        ArrayList ret = new ArrayList();
        Edge g = this.store.get(startIndex);
        if (g.getTo().equals(to)) {
            return new Edge[][]{new Edge[0]};
        }
        for (int i = startIndex + 1; i < this.store.size(); ++i) {
            Edge tmp = this.store.get(i);
            if (tmp == null) {
                throw new NullPointerException("access to bad index");
            }
            boolean vis = false;
            for (Edge v : visited) {
                if (v == null) {
                    throw new NullPointerException("OUCH got an null visited graph ... thats impossible (size is " + visited.length + ";v[0]=" + String.valueOf(visited[0]) + ";v[1]=" + String.valueOf(visited[1]) + ")");
                }
                if (!tmp.getTo().equals(v.getFrom()) && !tmp.getTo().equals(v.getTo())) continue;
                vis = true;
            }
            if (vis || !g.getTo().equals(tmp.getFrom())) continue;
            ArrayList<Edge> tg1 = new ArrayList<Edge>();
            tg1.addAll(Arrays.asList(visited));
            tg1.add(tmp);
            Edge[][] tg = this.getRoute(i, tg1.toArray(new Edge[tg1.size()]), to);
            for (int j = 0; j < tg.length; ++j) {
                Edge[] gj = tg[j];
                Edge[] gk = new Edge[gj.length + 1];
                if (gj.length > 0) {
                    System.arraycopy(gj, 0, gk, 1, gj.length);
                }
                gk[0] = tmp;
                tg[j] = gk;
            }
            ret.addAll(Arrays.asList(tg));
        }
        return (Edge[][])ret.toArray((T[])new Edge[ret.size()][]);
    }

    @Override
    public int compare(GraphSet g1, GraphSet g2) {
        if (g1.equals(g2)) {
            return 0;
        }
        return ("" + g1.hashCode()).compareTo("" + g2.hashCode());
    }

    @Override
    public int compareTo(GraphSet gs) {
        return this.compare(this, gs);
    }

    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object g) {
        if (g == null) {
            return false;
        }
        if (g.getClass() != this.getClass()) {
            GraphSet t = (GraphSet)g;
            if (t.store.size() != this.store.size()) {
                return false;
            }
            for (int i = 0; i < this.store.size(); ++i) {
                if (t.store.get(i) != null && this.get(i) != null && this.get(i).equals(t.store.get(i))) continue;
                return false;
            }
            return true;
        }
        return g == this;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (Edge g : this.store) {
            sb.append("  ").append(this.anonymitySet.indexOf(g.getFrom())).append(" -> ").append(this.anonymitySet.indexOf(g.getTo()));
        }
        sb.append('}');
        return sb.toString();
    }

    public RoutingCombo getRoutingBlock() {
        return null;
    }

    public int size() {
        return this.store.size();
    }

    public Edge get(int i) {
        return this.store.get(i);
    }

    @Override
    public Iterator<Edge> iterator() {
        return this.store.iterator();
    }
}

