/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.map.impl.query.Target;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryException;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractMapQueryMessageTask<P, QueryResult extends Result, AccumulatedResults, ReducedResult>
extends AbstractCallableMessageTask<P> {
    protected AbstractMapQueryMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.getDistributedObjectName(), "read");
    }

    protected String getUserCodeNamespace() {
        return MapService.lookupNamespace(this.nodeEngine, this.getDistributedObjectName());
    }

    protected abstract Predicate getPredicate();

    protected abstract Aggregator<?, ?> getAggregator();

    protected abstract Projection<?, ?> getProjection();

    protected abstract void extractAndAppendResult(Collection<AccumulatedResults> var1, QueryResult var2);

    protected abstract ReducedResult reduce(Collection<AccumulatedResults> var1);

    protected abstract IterationType getIterationType();

    @Override
    public Permission getUserCodeNamespacePermission() {
        String namespace = this.getUserCodeNamespace();
        return namespace != null ? new UserCodeNamespacePermission(namespace, "use") : null;
    }

    @Override
    protected final Object call() throws Exception {
        LinkedList result = new LinkedList();
        try {
            NamespaceUtil.setupNamespace(this.nodeEngine, this.getUserCodeNamespace());
            Predicate predicate = this.getPredicate();
            if (predicate instanceof PartitionPredicate) {
                PartitionPredicate partitionPredicate = (PartitionPredicate)predicate;
                QueryResult queryResult = this.invokeOnPartitions(partitionPredicate);
                this.extractAndAppendResult(result, queryResult);
                ReducedResult ReducedResult = this.reduce(result);
                return ReducedResult;
            }
            int partitionCount = this.clientEngine.getPartitionService().getPartitionCount();
            PartitionIdSet finishedPartitions = this.invokeOnMembers(result, predicate, partitionCount);
            this.invokeOnMissingPartitions(result, predicate, finishedPartitions);
            ReducedResult ReducedResult = this.reduce(result);
            return ReducedResult;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        finally {
            NamespaceUtil.cleanupNamespace(this.nodeEngine, this.getUserCodeNamespace());
        }
    }

    private QueryResult invokeOnPartitions(PartitionPredicate predicate) {
        MapService mapService = (MapService)this.nodeEngine.getService(this.getServiceName());
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        Query query = this.buildQuery(predicate);
        String name = query.getMapName();
        return (QueryResult)mapServiceContext.getQueryEngine(name).execute(query, Target.createPartitionTarget(query.getPartitionIdSet()));
    }

    private PartitionIdSet invokeOnMembers(Collection<AccumulatedResults> result, Predicate predicate, int partitionCount) {
        Collection<Member> members = this.clientEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        List<Future> futures = this.createInvocations(members, predicate);
        return this.collectResults(result, futures, partitionCount);
    }

    private void invokeOnMissingPartitions(Collection<AccumulatedResults> result, Predicate predicate, PartitionIdSet finishedPartitions) throws InterruptedException, ExecutionException {
        if (finishedPartitions.isMissingPartitions()) {
            PartitionIdSet missingPartitions = new PartitionIdSet(finishedPartitions);
            missingPartitions.complement();
            ArrayList<Future> missingFutures = new ArrayList<Future>(missingPartitions.size());
            this.createInvocationsForMissingPartitions(missingPartitions, missingFutures, predicate);
            this.collectResultsFromMissingPartitions(finishedPartitions, result, missingFutures);
        }
        this.assertAllPartitionsQueried(finishedPartitions);
    }

    private List<Future> createInvocations(Collection<Member> members, Predicate predicate) {
        ArrayList<Future> futures = new ArrayList<Future>(members.size());
        OperationService operationService = this.nodeEngine.getOperationService();
        Query query = this.buildQuery(predicate);
        MapService mapService = (MapService)this.nodeEngine.getService(this.getServiceName());
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        for (Member member : members) {
            try {
                InvocationFuture future = operationService.createInvocationBuilder("hz:impl:mapService", this.createQueryOperation(query, mapServiceContext), member.getAddress()).invoke();
                futures.add(future);
            }
            catch (Throwable t) {
                if (!(t instanceof HazelcastException)) {
                    throw ExceptionUtil.rethrow(t);
                }
                if (t.getCause() instanceof QueryResultSizeExceededException) {
                    throw ExceptionUtil.rethrow(t);
                }
                if (!this.logger.isFineEnabled()) continue;
                this.logger.fine("Query invocation failed on member " + member, t);
            }
        }
        return futures;
    }

    private Query buildQuery(Predicate predicate) {
        PartitionIdSet idSet;
        Predicate target;
        if (predicate instanceof PartitionPredicate) {
            PartitionPredicate partitionPredicate = (PartitionPredicate)predicate;
            target = partitionPredicate.getTarget();
            idSet = this.nodeEngine.getPartitionService().getPartitionIdSet(partitionPredicate.getPartitionKeys());
        } else {
            target = predicate;
            idSet = SetUtil.allPartitionIds(this.nodeEngine.getPartitionService().getPartitionCount());
        }
        Query.QueryBuilder builder = Query.of().mapName(this.getDistributedObjectName()).predicate(target).partitionIdSet(idSet).iterationType(this.getIterationType());
        if (this.getAggregator() != null) {
            builder = builder.aggregator(this.getAggregator());
        }
        if (this.getProjection() != null) {
            builder = builder.projection(this.getProjection());
        }
        return builder.build();
    }

    private PartitionIdSet collectResults(Collection<AccumulatedResults> result, List<Future> futures, int partitionCount) {
        PartitionIdSet finishedPartitions = new PartitionIdSet(partitionCount);
        for (Future future : futures) {
            try {
                PartitionIdSet partitionIds;
                Result queryResult = (Result)future.get();
                if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null || partitionIds.intersects(finishedPartitions)) continue;
                finishedPartitions.union(partitionIds);
                this.extractAndAppendResult(result, queryResult);
            }
            catch (Throwable t) {
                if (t.getCause() instanceof QueryResultSizeExceededException) {
                    throw ExceptionUtil.rethrow(t);
                }
                if (!this.logger.isFineEnabled()) continue;
                this.logger.fine("Query on member failed with exception", t);
            }
        }
        return finishedPartitions;
    }

    private void createInvocationsForMissingPartitions(PartitionIdSet missingPartitionsList, List<Future> futures, Predicate predicate) {
        OperationService operationService = this.nodeEngine.getOperationService();
        MapService mapService = (MapService)this.nodeEngine.getService(this.getServiceName());
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        Query query = this.buildQuery(predicate);
        PrimitiveIterator.OfInt missingPartitionIterator = missingPartitionsList.intIterator();
        missingPartitionIterator.forEachRemaining(partitionId -> {
            MapOperation queryPartitionOperation = this.createQueryPartitionOperation(query, mapServiceContext);
            queryPartitionOperation.setPartitionId(partitionId);
            try {
                InvocationFuture future = operationService.invokeOnPartition("hz:impl:mapService", queryPartitionOperation, partitionId);
                futures.add(future);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        });
    }

    private void collectResultsFromMissingPartitions(PartitionIdSet finishedPartitions, Collection<AccumulatedResults> result, List<Future> futures) throws InterruptedException, ExecutionException {
        for (Future future : futures) {
            Result queryResult = (Result)future.get();
            if (!CollectionUtil.isNotEmpty(queryResult.getPartitionIds()) || finishedPartitions.intersects(queryResult.getPartitionIds())) continue;
            this.extractAndAppendResult(result, queryResult);
            finishedPartitions.addAll(queryResult.getPartitionIds());
        }
    }

    private Operation createQueryOperation(Query query, MapServiceContext mapServiceContext) {
        return mapServiceContext.getMapOperationProvider(query.getMapName()).createQueryOperation(query);
    }

    private MapOperation createQueryPartitionOperation(Query query, MapServiceContext mapServiceContext) {
        return mapServiceContext.getMapOperationProvider(query.getMapName()).createQueryPartitionOperation(query);
    }

    private void assertAllPartitionsQueried(PartitionIdSet finishedPartitions) {
        if (finishedPartitions.isMissingPartitions()) {
            int missedPartitionsCount = 0;
            int partitionCount = finishedPartitions.getPartitionCount();
            for (int i = 0; i < partitionCount; ++i) {
                if (finishedPartitions.contains(i)) continue;
                ++missedPartitionsCount;
            }
            throw new QueryException("Query aborted. Could not execute query for all partitions. Missed " + missedPartitionsCount + " partitions");
        }
    }
}

