/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BTreeIndexConfig
implements IdentifiedDataSerializable {
    public static final Capacity DEFAULT_PAGE_SIZE = Capacity.of(16L, MemoryUnit.KILOBYTES);
    private Capacity pageSize = DEFAULT_PAGE_SIZE;
    private MemoryTierConfig memoryTierConfig = new MemoryTierConfig();

    public BTreeIndexConfig() {
    }

    public BTreeIndexConfig(BTreeIndexConfig other) {
        this.pageSize = other.pageSize;
        this.memoryTierConfig = other.memoryTierConfig == null ? null : new MemoryTierConfig(other.memoryTierConfig);
    }

    public Capacity getPageSize() {
        return this.pageSize;
    }

    public BTreeIndexConfig setPageSize(Capacity pageSize) {
        this.pageSize = Objects.requireNonNull(pageSize, "pageSize cannot be null");
        return this;
    }

    @Nonnull
    public MemoryTierConfig getMemoryTierConfig() {
        return this.memoryTierConfig;
    }

    public BTreeIndexConfig setMemoryTierConfig(MemoryTierConfig memoryTierConfig) {
        this.memoryTierConfig = Objects.requireNonNull(memoryTierConfig, "memoryTierConfig cannot be null");
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.pageSize.getValue());
        out.writeString(this.pageSize.getUnit().name());
        out.writeObject(this.memoryTierConfig);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        long size = in.readLong();
        MemoryUnit unit = MemoryUnit.valueOf(in.readString());
        this.pageSize = Capacity.of(size, unit);
        this.memoryTierConfig = (MemoryTierConfig)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 67;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BTreeIndexConfig that = (BTreeIndexConfig)o;
        return Objects.equals(this.getPageSize(), that.getPageSize()) && Objects.equals(this.getMemoryTierConfig(), that.getMemoryTierConfig());
    }

    public int hashCode() {
        return Objects.hash(this.getPageSize(), this.getMemoryTierConfig());
    }

    public String toString() {
        return "BTreeIndexConfig{pageSize=" + this.getPageSize() + ", memoryTierConfig=" + this.getMemoryTierConfig() + "}";
    }
}

