/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.IOException;

public class BeforeJoinCheckFailureOp
extends AbstractClusterOperation {
    private String failReasonMsg;

    public BeforeJoinCheckFailureOp() {
    }

    public BeforeJoinCheckFailureOp(String failReasonMsg) {
        this.failReasonMsg = failReasonMsg;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.failReasonMsg);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.failReasonMsg = in.readString();
    }

    @Override
    public void run() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Node node = nodeEngine.getNode();
        JoinOperation.verifyCanShutdown(node, this.failReasonMsg);
        ILogger logger = nodeEngine.getLogger("com.hazelcast.security");
        logger.severe("Node could not join cluster. Before join check failed node is going to shutdown now!");
        logger.severe("Reason of failure for node join: " + this.failReasonMsg);
        node.shutdown(true);
    }

    @Override
    public int getClassId() {
        return 8;
    }
}

