/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine;

import com.hazelcast.internal.tpcengine.Eventloop;
import com.hazelcast.internal.tpcengine.Promise;

final class ScheduledTask
implements Runnable,
Comparable<ScheduledTask> {
    final Eventloop eventloop;
    Promise promise;
    long deadlineNanos;
    Runnable task;
    long periodNanos = -1L;
    long delayNanos = -1L;

    ScheduledTask(Eventloop eventloop) {
        this.eventloop = eventloop;
    }

    @Override
    public void run() {
        if (this.task != null) {
            this.task.run();
        }
        if (this.periodNanos != -1L || this.delayNanos != -1L) {
            this.deadlineNanos = this.periodNanos != -1L ? (this.deadlineNanos += this.periodNanos) : this.eventloop.nanoClock.nanoTime() + this.delayNanos;
            if (this.deadlineNanos < 0L) {
                this.deadlineNanos = Long.MAX_VALUE;
            }
            if (!this.eventloop.scheduledTaskQueue.offer(this)) {
                this.eventloop.logger.warning("Failed schedule task: " + this + " because there is no space in scheduledTaskQueue");
            }
        } else if (this.promise != null) {
            this.promise.complete(null);
        }
    }

    @Override
    public int compareTo(ScheduledTask that) {
        if (that.deadlineNanos == this.deadlineNanos) {
            return 0;
        }
        return this.deadlineNanos > that.deadlineNanos ? 1 : -1;
    }

    public String toString() {
        return "ScheduledTask{promise=" + this.promise + ", deadlineNanos=" + this.deadlineNanos + ", task=" + this.task + ", periodNanos=" + this.periodNanos + ", delayNanos=" + this.delayNanos + "}";
    }
}

