/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.ascii.rest.RestCallCollector;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;

class RestApiMetricsProvider
implements MetricsProvider {
    RestApiMetricsProvider() {
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        RestCallCollector collector = node.getTextCommandService().getRestCallCollector();
        String enabled = node.getConfig().getNetworkConfig().getRestApiConfig().isEnabledAndNotEmpty() ? "1" : "0";
        context.collect(PhoneHomeMetrics.REST_ENABLED, enabled);
        context.collect(PhoneHomeMetrics.REST_MAP_POST_SUCCESS, collector.getMapPostSuccessCount());
        context.collect(PhoneHomeMetrics.REST_MAP_POST_FAILURE, collector.getMapPostFailureCount());
        context.collect(PhoneHomeMetrics.REST_MAP_DELETE_SUCCESS, collector.getMapDeleteSuccessCount());
        context.collect(PhoneHomeMetrics.REST_MAP_DELETE_FAILURE, collector.getMapDeleteFailureCount());
        context.collect(PhoneHomeMetrics.REST_MAP_GET_SUCCESS, collector.getMapGetSuccessCount());
        context.collect(PhoneHomeMetrics.REST_MAP_GET_FAILURE, collector.getMapGetFailureCount());
        context.collect(PhoneHomeMetrics.REST_MAP_TOTAL_REQUEST_COUNT, collector.getTotalMapRequestCount());
        context.collect(PhoneHomeMetrics.REST_ACCESSED_MAP_COUNT, collector.getAccessedMapCount());
        context.collect(PhoneHomeMetrics.REST_QUEUE_POST_SUCCESS, collector.getQueuePostSuccessCount());
        context.collect(PhoneHomeMetrics.REST_QUEUE_POST_FAILURE, collector.getQueuePostFailureCount());
        context.collect(PhoneHomeMetrics.REST_QUEUE_GET_SUCCESS, collector.getQueueGetSuccessCount());
        context.collect(PhoneHomeMetrics.REST_QUEUE_GET_FAILURE, collector.getQueueGetFailureCount());
        context.collect(PhoneHomeMetrics.REST_QUEUE_DELETE_SUCCESS, collector.getQueueDeleteSuccessCount());
        context.collect(PhoneHomeMetrics.REST_QUEUE_DELETE_FAILURE, collector.getQueueDeleteFailureCount());
        context.collect(PhoneHomeMetrics.REST_ACCESSED_QUEUE_COUNT, collector.getAccessedQueueCount());
        context.collect(PhoneHomeMetrics.REST_QUEUE_TOTAL_REQUEST_COUNT, collector.getTotalQueueRequestCount());
        context.collect(PhoneHomeMetrics.REST_CONFIG_UPDATE_SUCCESS, collector.getConfigUpdateSuccessCount());
        context.collect(PhoneHomeMetrics.REST_CONFIG_UPDATE_FAILURE, collector.getConfigUpdateFailureCount());
        context.collect(PhoneHomeMetrics.REST_CONFIG_RELOAD_SUCCESS, collector.getConfigReloadSuccessCount());
        context.collect(PhoneHomeMetrics.REST_CONFIG_RELOAD_FAILURE, collector.getConfigReloadFailureCount());
        context.collect(PhoneHomeMetrics.REST_REQUEST_COUNT, collector.getRequestCount());
        context.collect(PhoneHomeMetrics.REST_UNIQUE_REQUEST_COUNT, collector.getUniqueRequestCount());
    }
}

