/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.VectorStringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class MultiIndexVectorValues
implements VectorValues.MultiIndexVectorValues,
IdentifiedDataSerializable {
    private Map<String, float[]> indexNameToVector;

    public MultiIndexVectorValues() {
    }

    public MultiIndexVectorValues(Map<String, float[]> indexNameToVector) {
        this.indexNameToVector = indexNameToVector;
    }

    @Override
    public Map<String, float[]> indexNameToVector() {
        return this.indexNameToVector;
    }

    public String toString() {
        return "MultiIndexVectorValues{indexNameToVector=" + VectorStringUtil.mapToString(this.indexNameToVector) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorValues.MultiIndexVectorValues that = (VectorValues.MultiIndexVectorValues)o;
        Map<String, float[]> m = that.indexNameToVector();
        if (m.size() != this.indexNameToVector.size()) {
            return false;
        }
        try {
            for (Map.Entry<String, float[]> e : this.indexNameToVector.entrySet()) {
                String key = e.getKey();
                float[] value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !Arrays.equals(value, m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.indexNameToVector);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeMapStringKey(this.indexNameToVector, out, ObjectDataOutput::writeFloatArray);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.indexNameToVector = SerializationUtil.readMapStringKey(in, ObjectDataInput::readFloatArray);
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 16;
    }
}

