/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.OverlayPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class BackgroundPaintingUtils {
    public static void updateIfOpaque(Graphics g, Component c) {
        if (SubstanceCoreUtilities.isOpaque(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
    }

    public static void update(Graphics g, Component c, boolean force) {
        BackgroundPaintingUtils.update(g, c, force, null);
    }

    public static void update(Graphics g, Component c, boolean force, DecorationAreaType decorationType) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("lafwidgets.internal.previewMode"));
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite(c, g));
        if (decorationType == null) {
            decorationType = SubstanceLookAndFeel.getDecorationType(c);
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        boolean isShowing = c.isShowing();
        if (isShowing && decorationType != DecorationAreaType.NONE && skin.isRegisteredAsDecorationArea(decorationType)) {
            DecorationPainterUtils.paintDecorationBackground(graphics, c, decorationType, force);
            OverlayPainterUtils.paintOverlays(graphics, c, skin, decorationType);
        } else {
            Color backgr = SubstanceColorUtilities.getBackgroundFillColor((c instanceof JTextComponent || c instanceof JSpinner) && c.getParent() != null ? c.getParent() : c);
            graphics.setColor(backgr);
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
            if (isShowing) {
                OverlayPainterUtils.paintOverlays(graphics, c, skin, decorationType);
                SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
                if (watermark != null && !isPreviewMode && !isInCellRenderer && SubstanceCoreUtilities.toDrawWatermark(c)) {
                    watermark.drawWatermarkImage(graphics, c, 0, 0, c.getWidth(), c.getHeight());
                }
            }
        }
        graphics.dispose();
    }

    public static void fillAndWatermark(Graphics g, JComponent c, Color fillColor, Rectangle rect) {
        boolean isInCellRenderer;
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        boolean bl = isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        if (!c.isShowing() && !isInCellRenderer) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)c, g));
        graphics.setColor(fillColor);
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite(c, 1.0f, g));
        SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
        if (watermark != null && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
            watermark.drawWatermarkImage(graphics, c, rect.x, rect.y, rect.width, rect.height);
        }
        graphics.dispose();
    }
}

