/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.namespace.impl.NodeEngineThreadLocalContext;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import java.io.IOException;
import javax.cache.configuration.CacheEntryListenerConfiguration;

public class CacheListenerRegistrationOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable {
    private CacheEntryListenerConfiguration cacheEntryListenerConfiguration;
    private boolean register;

    public CacheListenerRegistrationOperation() {
    }

    public CacheListenerRegistrationOperation(String name, CacheEntryListenerConfiguration cacheEntryListenerConfiguration, boolean register) {
        super(name);
        this.cacheEntryListenerConfiguration = cacheEntryListenerConfiguration;
        this.register = register;
    }

    @Override
    public void run() throws Exception {
        AbstractCacheService service = (AbstractCacheService)this.getService();
        CacheConfig cacheConfig = service.getCacheConfig(this.name);
        if (this.register) {
            service.cacheEntryListenerRegistered(this.name, this.cacheEntryListenerConfiguration);
        } else if (cacheConfig != null) {
            service.cacheEntryListenerDeregistered(this.name, this.cacheEntryListenerConfiguration);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.cacheEntryListenerConfiguration);
        out.writeBoolean(this.register);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContext();
        this.cacheEntryListenerConfiguration = NamespaceUtil.callWithNamespace(engine, CacheService.lookupNamespace(engine, this.name), in::readObject);
        this.register = in.readBoolean();
    }

    @Override
    public int getClassId() {
        return 28;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }
}

