/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.operations.OperationFactoryWrapper;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractAllPartitionsMessageTask<P>
extends AbstractAsyncMessageTask<P, Map<Integer, Object>> {
    private boolean namespaceAware;

    public AbstractAllPartitionsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected final void setNamespaceAware() {
        this.namespaceAware = true;
    }

    @Override
    protected void processMessage() {
        if (this.namespaceAware) {
            NamespaceUtil.runWithNamespace(this.nodeEngine, this.getUserCodeNamespace(), () -> super.processMessage());
        } else {
            super.processMessage();
        }
    }

    @Override
    protected CompletableFuture<Map<Integer, Object>> processInternal() {
        OperationFactoryWrapper operationFactory = new OperationFactoryWrapper(this.createOperationFactory(), this.endpoint.getUuid());
        OperationService operationService = this.nodeEngine.getOperationService();
        return operationService.invokeOnAllPartitionsAsync(this.getServiceName(), operationFactory);
    }

    @Override
    protected Object processResponseBeforeSending(Map<Integer, Object> response) {
        return this.reduce(response);
    }

    protected abstract OperationFactory createOperationFactory();

    protected abstract Object reduce(Map<Integer, Object> var1);

    protected abstract String getUserCodeNamespace();
}

