/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TopicAddMessageListenerCodec;
import com.hazelcast.client.impl.protocol.codec.TopicPublishAllCodec;
import com.hazelcast.client.impl.protocol.codec.TopicPublishCodec;
import com.hazelcast.client.impl.protocol.codec.TopicRemoveMessageListenerCodec;
import com.hazelcast.client.impl.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.LocalTopicStats;
import com.hazelcast.topic.MessageListener;
import com.hazelcast.topic.impl.DataAwareMessage;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ClientTopicProxy<E>
extends PartitionSpecificClientProxy
implements ITopic<E> {
    private static final String NULL_MESSAGE_IS_NOT_ALLOWED = "Null message is not allowed!";
    private static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";

    public ClientTopicProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    @Override
    public void publish(@Nonnull E message) {
        Preconditions.checkNotNull(message, NULL_MESSAGE_IS_NOT_ALLOWED);
        Data data = this.toData(message);
        ClientMessage request = TopicPublishCodec.encodeRequest(this.name, data);
        this.invokeOnPartition(request);
    }

    public InternalCompletableFuture<Void> publishAsync(@Nonnull E message) {
        Preconditions.checkNotNull(message, NULL_MESSAGE_IS_NOT_ALLOWED);
        Data data = this.toData(message);
        ClientMessage request = TopicPublishCodec.encodeRequest(this.name, data);
        return this.invokeOnPartitionAsync(request, clientMessage -> null);
    }

    @Override
    @Nonnull
    public UUID addMessageListener(@Nonnull MessageListener<E> listener) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        TopicItemHandler handler = new TopicItemHandler(listener);
        return this.registerListener(new Codec(), handler);
    }

    @Override
    public boolean removeMessageListener(@Nonnull UUID registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    @Nonnull
    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    @Override
    public void publishAll(@Nonnull Collection<? extends E> messages) {
        Preconditions.checkNotNull(messages, NULL_MESSAGE_IS_NOT_ALLOWED);
        Preconditions.checkNoNullInside(messages, NULL_MESSAGE_IS_NOT_ALLOWED);
        ClientMessage request = this.getClientMessage(messages);
        this.invokeOnPartition(request);
    }

    public InternalCompletableFuture<Void> publishAllAsync(@Nonnull Collection<? extends E> messages) {
        Preconditions.checkNotNull(messages, NULL_MESSAGE_IS_NOT_ALLOWED);
        Preconditions.checkNoNullInside(messages, NULL_MESSAGE_IS_NOT_ALLOWED);
        ClientMessage request = this.getClientMessage(messages);
        return this.invokeOnPartitionAsync(request, clientMessage -> null);
    }

    private ClientMessage getClientMessage(@Nonnull Collection<? extends E> messages) {
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(messages, this.getSerializationService());
        return TopicPublishAllCodec.encodeRequest(this.name, dataCollection);
    }

    public String toString() {
        return "ITopic{name='" + this.name + "'}";
    }

    private final class TopicItemHandler
    extends TopicAddMessageListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final MessageListener<E> listener;

        private TopicItemHandler(MessageListener<E> listener) {
            this.listener = listener;
        }

        @Override
        public void handleTopicEvent(Data item, long publishTime, UUID uuid) {
            Member member = ClientTopicProxy.this.getContext().getClusterService().getMember(uuid);
            DataAwareMessage message = new DataAwareMessage(ClientTopicProxy.this.name, item, publishTime, member, ClientTopicProxy.this.getSerializationService());
            this.listener.onMessage(message);
        }
    }

    private class Codec
    implements ListenerMessageCodec {
        private Codec() {
        }

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return TopicAddMessageListenerCodec.encodeRequest(ClientTopicProxy.this.name, localOnly);
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return TopicAddMessageListenerCodec.decodeResponse(clientMessage);
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return TopicRemoveMessageListenerCodec.encodeRequest(ClientTopicProxy.this.name, realRegistrationId);
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return TopicRemoveMessageListenerCodec.decodeResponse(clientMessage);
        }
    }
}

