/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DiskTierConfig
implements IdentifiedDataSerializable {
    private boolean enabled;
    private String deviceName = "default-tiered-store-device";

    public DiskTierConfig() {
    }

    public DiskTierConfig(DiskTierConfig diskTierConfig) {
        this.enabled = diskTierConfig.isEnabled();
        this.deviceName = diskTierConfig.getDeviceName();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DiskTierConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public DiskTierConfig setDeviceName(@Nonnull String deviceName) {
        this.deviceName = Preconditions.checkNotNull(deviceName, "Device name must not be null");
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeString(this.deviceName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.deviceName = in.readString();
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 66;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiskTierConfig)) {
            return false;
        }
        DiskTierConfig that = (DiskTierConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return Objects.equals(this.deviceName, that.deviceName);
    }

    public final int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.deviceName != null ? this.deviceName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DiskTierConfig{enabled=" + this.enabled + ", deviceName='" + this.deviceName + "'}";
    }
}

