/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.namespace.ResourceDefinition;
import com.hazelcast.internal.namespace.impl.ResourceDefinitionImpl;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserCodeNamespaceConfig
implements NamedConfig,
IdentifiedDataSerializable {
    private String name;
    private final Map<String, ResourceDefinition> resourceDefinitions = new ConcurrentHashMap<String, ResourceDefinition>();

    public UserCodeNamespaceConfig() {
    }

    public UserCodeNamespaceConfig(String name) {
        this.name = name;
    }

    public UserCodeNamespaceConfig(UserCodeNamespaceConfig config) {
        this.name = config.name;
        this.resourceDefinitions.putAll(config.resourceDefinitions);
    }

    public UserCodeNamespaceConfig(@Nonnull String name, @Nonnull Map<String, ResourceDefinition> resources) {
        this.name = name;
        this.resourceDefinitions.putAll(resources);
    }

    @Override
    public UserCodeNamespaceConfig setName(@Nonnull String name) {
        Objects.requireNonNull(name, "Namespace name cannot be null");
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UserCodeNamespaceConfig addClass(Class<?> ... classes) {
        Objects.requireNonNull(classes, "Classes cannot be null");
        ResourceConfig.fromClass(classes).map(ResourceDefinitionImpl::new).forEach(resourceDefinition -> this.resourceDefinitions.put(resourceDefinition.id(), (ResourceDefinition)resourceDefinition));
        return this;
    }

    public UserCodeNamespaceConfig addClass(@Nonnull URL url, @Nullable String id) {
        return this.add(new ResourceDefinitionImpl(new ResourceConfig(url, id, ResourceType.CLASS)));
    }

    public UserCodeNamespaceConfig addJar(@Nonnull URL url, @Nullable String id) {
        return this.add(url, id, ResourceType.JAR);
    }

    public UserCodeNamespaceConfig addJarsInZip(@Nonnull URL url, @Nullable String id) {
        return this.add(url, id, ResourceType.JARS_IN_ZIP);
    }

    UserCodeNamespaceConfig add(@Nonnull URL url, @Nullable String id, @Nonnull ResourceType resourceType) {
        return this.add(new ResourceDefinitionImpl(new ResourceConfig(url, id, resourceType)));
    }

    protected UserCodeNamespaceConfig add(ResourceDefinition resourceDefinition) {
        if (this.resourceDefinitions.putIfAbsent(resourceDefinition.id(), resourceDefinition) != null) {
            throw new IllegalArgumentException("Resource with id: " + resourceDefinition.id() + " already exists");
        }
        return this;
    }

    Set<ResourceDefinition> getResourceConfigs() {
        return Set.copyOf(this.resourceDefinitions.values());
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        SerializationUtil.writeMapStringKey(this.resourceDefinitions, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        int size = in.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            this.resourceDefinitions.put(in.readString(), (ResourceDefinition)in.readObject());
        }
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 70;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UserCodeNamespaceConfig other = (UserCodeNamespaceConfig)obj;
        return Objects.equals(this.name, other.name);
    }
}

