/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.jmx;

import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.MetricsPublisher;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.metrics.impl.DefaultMetricDescriptorSupplier;
import com.hazelcast.internal.metrics.jmx.MetricsMBean;
import com.hazelcast.internal.util.MutableInteger;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxPublisher
implements MetricsPublisher {
    private final MBeanServer platformMBeanServer;
    private final String instanceNameEscaped;
    private final String domainPrefix;
    private final Map<MetricDescriptor, MetricData> metricNameToMetricData = new HashMap<MetricDescriptor, MetricData>();
    private final Map<ObjectName, MetricsMBean> mBeans = new HashMap<ObjectName, MetricsMBean>();
    private volatile boolean isShutdown;
    private final Function<MetricDescriptor, MetricData> createMetricDataFunction;
    private final Function<? super ObjectName, ? extends MetricsMBean> createMBeanFunction;

    public JmxPublisher(String instanceName, String domainPrefix) {
        this.domainPrefix = domainPrefix;
        this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.instanceNameEscaped = JmxPublisher.escapeObjectNameValue(instanceName);
        this.createMetricDataFunction = n -> new MetricData((MetricDescriptor)n, this.instanceNameEscaped, domainPrefix);
        this.createMBeanFunction = objectName -> {
            MetricsMBean bean = new MetricsMBean();
            try {
                this.platformMBeanServer.registerMBean(bean, (ObjectName)objectName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return bean;
        };
    }

    @Override
    public String name() {
        return "JMX Publisher";
    }

    @Override
    public void publishLong(MetricDescriptor descriptor, long value) {
        this.publishNumber(descriptor, value, MetricsMBean.Type.LONG);
    }

    @Override
    public void publishDouble(MetricDescriptor descriptor, double value) {
        this.publishNumber(descriptor, value, MetricsMBean.Type.DOUBLE);
    }

    private void publishNumber(MetricDescriptor originalDescriptor, Number value, MetricsMBean.Type type) {
        MetricData metricData;
        if (originalDescriptor.isTargetExcluded(MetricTarget.JMX)) {
            return;
        }
        if (!this.metricNameToMetricData.containsKey(originalDescriptor)) {
            MetricDescriptor descriptor = this.copy(originalDescriptor);
            metricData = this.metricNameToMetricData.computeIfAbsent(descriptor, this.createMetricDataFunction);
        } else {
            metricData = this.metricNameToMetricData.get(originalDescriptor);
        }
        this.assertDoubleRendering(originalDescriptor, metricData, value);
        metricData.wasPresent = true;
        MetricsMBean mBean = this.mBeans.computeIfAbsent(metricData.objectName, this.createMBeanFunction);
        if (this.isShutdown) {
            this.unregisterMBeanIgnoreError(metricData.objectName);
        }
        mBean.setMetricValue(metricData.metric, metricData.unit, value, type);
    }

    private void assertDoubleRendering(MetricDescriptor originalDescriptor, MetricData metricData, Number newValue) {
        assert (!metricData.wasPresent) : "metric '" + originalDescriptor.toString() + "' was rendered twice. Present value: " + this.metricValue(metricData) + ", new value: " + newValue;
    }

    private Number metricValue(MetricData metricData) {
        try {
            return (Number)this.mBeans.get(metricData.objectName).getAttribute(metricData.metric);
        }
        catch (AttributeNotFoundException ex) {
            throw new IllegalStateException("Metric is marked as present but no mBean is registered with object name '" + metricData.objectName + "' and attribute '" + metricData.metric + "'");
        }
    }

    private MetricDescriptor copy(MetricDescriptor descriptor) {
        return DefaultMetricDescriptorSupplier.DEFAULT_DESCRIPTOR_SUPPLIER.get().copy(descriptor);
    }

    private void unregisterMBeanIgnoreError(ObjectName objectName) {
        try {
            this.platformMBeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void whenComplete() {
        Iterator<MetricData> iterator = this.metricNameToMetricData.values().iterator();
        while (iterator.hasNext()) {
            MetricData metricData = iterator.next();
            if (!metricData.wasPresent) {
                iterator.remove();
                MetricsMBean mBean = this.mBeans.get(metricData.objectName);
                mBean.removeMetric(metricData.metric);
                if (mBean.numAttributes() != 0) continue;
                this.mBeans.remove(metricData.objectName);
                this.unregisterMBeanIgnoreError(metricData.objectName);
                continue;
            }
            metricData.wasPresent = false;
        }
    }

    static String escapeObjectNameValue(String name) {
        if (!JmxPublisher.shouldEscapeObjectNameValue(name)) {
            return name;
        }
        int length = name.length();
        StringBuilder builder = new StringBuilder(length + 8);
        builder.append('\"');
        for (int i2 = 0; i2 < length; ++i2) {
            char ch = name.charAt(i2);
            if (ch == '\\' || ch == '\"' || ch == '*' || ch == '?') {
                builder.append('\\');
            }
            if (ch == '\n') {
                builder.append("\\n");
                continue;
            }
            builder.append(ch);
        }
        builder.append('\"');
        return builder.toString();
    }

    private static boolean shouldEscapeObjectNameValue(String name) {
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char ch = name.charAt(i2);
            if (ch != '=' && ch != ':' && ch != '*' && ch != '?' && ch != '\"' && ch != '\n') continue;
            return true;
        }
        return false;
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
        if (this.platformMBeanServer == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName(this.domainPrefix + "*:instance=" + this.instanceNameEscaped + ",type=Metrics,*");
            for (ObjectName bean : this.platformMBeanServer.queryNames(name, null)) {
                this.unregisterMBeanIgnoreError(bean);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Exception when unregistering JMX beans", e);
        }
    }

    private static class MetricData {
        public static final int INITIAL_MBEAN_BUILDER_CAPACITY = 250;
        public static final int INITIAL_MODULE_BUILDER_CAPACITY = 350;
        ObjectName objectName;
        String metric;
        String unit;
        boolean wasPresent;

        MetricData(MetricDescriptor descriptor, String instanceNameEscaped, String domainPrefix) {
            StringBuilder mBeanTags = new StringBuilder(250);
            StringBuilder moduleBuilder = new StringBuilder(350);
            String module = null;
            this.metric = descriptor.metric();
            ProbeUnit descriptorUnit = descriptor.unit();
            this.unit = descriptorUnit != null ? descriptorUnit.name() : "unknown";
            MutableInteger tagCnt = new MutableInteger();
            for (int i2 = 0; i2 < descriptor.tagCount(); ++i2) {
                String tag = descriptor.tag(i2);
                String tagValue = descriptor.tagValue(i2);
                if ("module".equals(tag)) {
                    moduleBuilder.append(tagValue);
                    continue;
                }
                if (mBeanTags.length() > 0) {
                    mBeanTags.append(',');
                }
                int newTagIdx = tagCnt.getAndInc();
                mBeanTags.append("tag").append(newTagIdx).append('=').append(JmxPublisher.escapeObjectNameValue(tag + "=" + tagValue));
            }
            if (moduleBuilder.length() > 0) {
                module = moduleBuilder.toString();
            }
            String discriminator = descriptor.discriminator();
            String discriminatorValue = descriptor.discriminatorValue();
            if (discriminator != null && discriminatorValue != null) {
                if (mBeanTags.length() > 0) {
                    mBeanTags.append(',');
                }
                int newTagIdx = tagCnt.getAndInc();
                mBeanTags.append("tag").append(newTagIdx).append("=").append(JmxPublisher.escapeObjectNameValue(discriminator + "=" + discriminatorValue));
            }
            assert (this.metric != null) : "metric == null";
            StringBuilder objectNameStr = new StringBuilder(mBeanTags.length() + 64);
            objectNameStr.append(domainPrefix);
            if (module != null) {
                objectNameStr.append('.').append(module);
            }
            objectNameStr.append(":type=Metrics");
            objectNameStr.append(",instance=").append(instanceNameEscaped);
            if (descriptor.prefix() != null) {
                objectNameStr.append(",prefix=").append(JmxPublisher.escapeObjectNameValue(descriptor.prefix()));
            }
            if (mBeanTags.length() > 0) {
                objectNameStr.append(',').append((CharSequence)mBeanTags);
            }
            try {
                this.objectName = new ObjectName(objectNameStr.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

