/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.WatermarkPolicy;
import com.hazelcast.jet.core.function.ObjLongBiFunction;
import com.hazelcast.jet.impl.util.Util;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class EventTimePolicy<T>
implements Serializable {
    public static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private static final long serialVersionUID = 1L;
    private static final ObjLongBiFunction<?, ?> NO_WRAPPING = (event, timestamp) -> event;
    private static final SupplierEx<WatermarkPolicy> NO_WATERMARKS = () -> new WatermarkPolicy(){

        @Override
        public void reportEvent(long timestamp) {
        }

        @Override
        public long getCurrentWatermark() {
            return Long.MIN_VALUE;
        }
    };
    private final ToLongFunctionEx<? super T> timestampFn;
    private final ObjLongBiFunction<? super T, ?> wrapFn;
    private final SupplierEx<? extends WatermarkPolicy> newWmPolicyFn;
    private final long watermarkThrottlingFrameSize;
    private final long watermarkThrottlingFrameOffset;
    private final long idleTimeoutMillis;
    private final byte wmKey;

    private EventTimePolicy(@Nullable ToLongFunctionEx<? super T> timestampFn, @Nonnull ObjLongBiFunction<? super T, ?> wrapFn, @Nonnull SupplierEx<? extends WatermarkPolicy> newWmPolicyFn, long watermarkThrottlingFrameSize, long watermarkThrottlingFrameOffset, long idleTimeoutMillis, byte wmKey) {
        Preconditions.checkNotNegative(watermarkThrottlingFrameSize, "watermarkThrottlingFrameSize must be >= 0");
        Preconditions.checkNotNegative(watermarkThrottlingFrameOffset, "watermarkThrottlingFrameOffset must be >= 0");
        Preconditions.checkTrue(watermarkThrottlingFrameOffset < watermarkThrottlingFrameSize || watermarkThrottlingFrameSize == 0L, "offset must be smaller than frame size");
        Preconditions.checkNotNegative(idleTimeoutMillis, "idleTimeoutMillis must be >= 0 (0 means disabled)");
        this.timestampFn = timestampFn;
        this.newWmPolicyFn = newWmPolicyFn;
        this.wrapFn = wrapFn;
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.watermarkThrottlingFrameSize = watermarkThrottlingFrameSize;
        this.watermarkThrottlingFrameOffset = watermarkThrottlingFrameOffset;
        this.wmKey = wmKey;
    }

    public static <T> EventTimePolicy<T> eventTimePolicy(@Nullable ToLongFunctionEx<? super T> timestampFn, @Nonnull ObjLongBiFunction<? super T, ?> wrapFn, @Nonnull SupplierEx<? extends WatermarkPolicy> newWmPolicyFn, long watermarkThrottlingFrameSize, long watermarkThrottlingFrameOffset, long idleTimeoutMillis) {
        return EventTimePolicy.eventTimePolicy(timestampFn, wrapFn, newWmPolicyFn, watermarkThrottlingFrameSize, watermarkThrottlingFrameOffset, idleTimeoutMillis, (byte)0);
    }

    public static <T> EventTimePolicy<T> eventTimePolicy(@Nullable ToLongFunctionEx<? super T> timestampFn, @Nonnull ObjLongBiFunction<? super T, ?> wrapFn, @Nonnull SupplierEx<? extends WatermarkPolicy> newWmPolicyFn, long watermarkThrottlingFrameSize, long watermarkThrottlingFrameOffset, long idleTimeoutMillis, byte wmKey) {
        Util.checkSerializable(timestampFn, "timestampFn");
        Util.checkSerializable(wrapFn, "wrapFn");
        Util.checkSerializable(newWmPolicyFn, "newWmPolicyFn");
        return new EventTimePolicy<T>(timestampFn, wrapFn, newWmPolicyFn, watermarkThrottlingFrameSize, watermarkThrottlingFrameOffset, idleTimeoutMillis, wmKey);
    }

    public static <T> EventTimePolicy<T> eventTimePolicy(@Nullable ToLongFunctionEx<? super T> timestampFn, @Nonnull SupplierEx<? extends WatermarkPolicy> newWmPolicyFn, long watermarkThrottlingFrameSize, long watermarkThrottlingFrameOffset, long idleTimeoutMillis) {
        return EventTimePolicy.eventTimePolicy(timestampFn, EventTimePolicy.noWrapping(), newWmPolicyFn, watermarkThrottlingFrameSize, watermarkThrottlingFrameOffset, idleTimeoutMillis, (byte)0);
    }

    public static <T> EventTimePolicy<T> noEventTime() {
        return EventTimePolicy.eventTimePolicy(i2 -> Long.MIN_VALUE, EventTimePolicy.noWrapping(), NO_WATERMARKS, 0L, 0L, 0L, (byte)0);
    }

    private static <T> ObjLongBiFunction<T, Object> noWrapping() {
        return NO_WRAPPING;
    }

    @Nullable
    public ToLongFunctionEx<? super T> timestampFn() {
        return this.timestampFn;
    }

    @Nonnull
    public ObjLongBiFunction<? super T, ?> wrapFn() {
        return this.wrapFn;
    }

    @Nonnull
    public SupplierEx<? extends WatermarkPolicy> newWmPolicyFn() {
        return this.newWmPolicyFn;
    }

    public long watermarkThrottlingFrameSize() {
        return this.watermarkThrottlingFrameSize;
    }

    public long watermarkThrottlingFrameOffset() {
        return this.watermarkThrottlingFrameOffset;
    }

    public long idleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public byte wmKey() {
        return this.wmKey;
    }
}

