/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetAddJobStatusListenerCodec;
import com.hazelcast.client.impl.protocol.codec.JetExportSnapshotCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobConfigCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobMetricsCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobStatusCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobSubmissionTimeCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobSuspensionCauseCodec;
import com.hazelcast.client.impl.protocol.codec.JetIsJobUserCancelledCodec;
import com.hazelcast.client.impl.protocol.codec.JetJoinSubmittedJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetRemoveJobStatusListenerCodec;
import com.hazelcast.client.impl.protocol.codec.JetResumeJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetSubmitJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetTerminateJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetUpdateJobConfigCodec;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.impl.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.JobStatusEvent;
import com.hazelcast.jet.JobStatusListener;
import com.hazelcast.jet.config.DeltaJobConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.core.JobSuspensionCause;
import com.hazelcast.jet.core.metrics.JobMetrics;
import com.hazelcast.jet.impl.AbstractJobProxy;
import com.hazelcast.jet.impl.JobMetricsUtil;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientJobProxy
extends AbstractJobProxy<HazelcastClientInstanceImpl, UUID> {
    private static final long RETRY_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(200L);
    private static final long RETRY_TIME_NS = TimeUnit.SECONDS.toNanos(60L);

    ClientJobProxy(HazelcastClientInstanceImpl client, long jobId, UUID coordinator) {
        super(client, jobId, coordinator);
    }

    ClientJobProxy(HazelcastClientInstanceImpl client, long jobId, boolean isLightJob, @Nonnull Object jobDefinition, @Nonnull JobConfig config) {
        super(client, jobId, isLightJob, jobDefinition, config, null);
    }

    @Override
    @Nonnull
    protected JobStatus getStatus0() {
        assert (!this.isLightJob());
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetGetJobStatusCodec.encodeRequest(this.getId());
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterId()).invoke().get();
            int jobStatusIndex = JetGetJobStatusCodec.decodeResponse(response);
            return JobStatus.values()[jobStatusIndex];
        });
    }

    @Override
    protected boolean isUserCancelled0() {
        assert (!this.isLightJob());
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetIsJobUserCancelledCodec.encodeRequest(this.getId());
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterId()).invoke().get();
            return JetIsJobUserCancelledCodec.decodeResponse(response);
        });
    }

    @Override
    @Nonnull
    public JobSuspensionCause getSuspensionCause() {
        this.checkNotLightJob("suspensionCause");
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetGetJobSuspensionCauseCodec.encodeRequest(this.getId());
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterId()).invoke().get();
            Data data = JetGetJobSuspensionCauseCodec.decodeResponse(response);
            return (JobSuspensionCause)this.serializationService().toObject(data);
        });
    }

    @Override
    @Nonnull
    public JobMetrics getMetrics() {
        this.checkNotLightJob("metrics");
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetGetJobMetricsCodec.encodeRequest(this.getId());
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterId()).invoke().get();
            Data metricsData = JetGetJobMetricsCodec.decodeResponse(response);
            return JobMetricsUtil.toJobMetrics((List)this.serializationService().toObject(metricsData));
        });
    }

    @Override
    protected UUID findLightJobCoordinator() {
        ClientConnection connection = ((HazelcastClientInstanceImpl)this.container()).getConnectionManager().getRandomConnection();
        if (connection == null) {
            throw new JetException("The client isn't connected to the cluster");
        }
        return connection.getRemoteUuid();
    }

    @Override
    protected CompletableFuture<Void> invokeSubmitJob(Object jobDefinition, JobConfig config) {
        Object configData = this.serializationService().toData(config);
        Object jobDefinitionData = this.serializationService().toData(jobDefinition);
        ClientMessage request = JetSubmitJobCodec.encodeRequest(this.getId(), jobDefinitionData, configData, (UUID)this.lightJobCoordinator);
        return this.invocation(request, (UUID)this.coordinatorId()).invoke().thenApply(c -> null);
    }

    @Override
    protected CompletableFuture<Void> invokeJoinJob() {
        ClientMessage request = JetJoinSubmittedJobCodec.encodeRequest(this.getId(), (UUID)this.lightJobCoordinator);
        ClientInvocation invocation = this.invocation(request, (UUID)this.coordinatorId());
        invocation.setInvocationTimeoutMillis(Long.MAX_VALUE);
        return invocation.invoke().thenApply(c -> null);
    }

    @Override
    protected CompletableFuture<Void> invokeTerminateJob(TerminationMode mode) {
        ClientMessage request = JetTerminateJobCodec.encodeRequest(this.getId(), mode.ordinal(), (UUID)this.lightJobCoordinator);
        return this.invocation(request, (UUID)this.coordinatorId()).invoke().thenApply(c -> null);
    }

    @Override
    public void resume() {
        this.checkNotLightJob("resume");
        ClientMessage request = JetResumeJobCodec.encodeRequest(this.getId());
        try {
            this.invocation(request, this.masterId()).invoke().get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    protected JobStateSnapshot doExportSnapshot(String name, boolean cancelJob) {
        this.checkNotLightJob("export snapshot");
        ClientMessage request = JetExportSnapshotCodec.encodeRequest(this.getId(), name, cancelJob);
        try {
            this.invocation(request, this.masterId()).invoke().get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return ((HazelcastClientInstanceImpl)this.container()).getJet().getJobStateSnapshot(name);
    }

    @Override
    protected long doGetJobSubmissionTime() {
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetGetJobSubmissionTimeCodec.encodeRequest(this.getId(), (UUID)this.lightJobCoordinator);
            ClientMessage response = (ClientMessage)this.invocation(request, (UUID)this.coordinatorId()).invoke().get();
            return JetGetJobSubmissionTimeCodec.decodeResponse(response);
        });
    }

    @Override
    protected JobConfig doGetJobConfig() {
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetGetJobConfigCodec.encodeRequest(this.getId(), (UUID)this.lightJobCoordinator);
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterId()).invoke().get();
            Data data = JetGetJobConfigCodec.decodeResponse(response);
            return (JobConfig)this.serializationService().toObject(data);
        });
    }

    @Override
    protected JobConfig doUpdateJobConfig(@Nonnull DeltaJobConfig deltaConfig) {
        return this.callAndRetryIfTargetNotFound(() -> {
            Object deltaConfigData = this.serializationService().toData(deltaConfig);
            ClientMessage request = JetUpdateJobConfigCodec.encodeRequest(this.getId(), deltaConfigData);
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterId()).invoke().get();
            Data configData = JetUpdateJobConfigCodec.decodeResponse(response);
            return (JobConfig)this.serializationService().toObject(configData);
        });
    }

    @Override
    @Nonnull
    protected UUID masterId() {
        Member masterMember = ((HazelcastClientInstanceImpl)this.container()).getClientClusterService().getMasterMember();
        if (masterMember == null) {
            throw new IllegalStateException("Master isn't known");
        }
        return masterMember.getUuid();
    }

    @Override
    protected SerializationService serializationService() {
        return ((HazelcastClientInstanceImpl)this.container()).getSerializationService();
    }

    @Override
    protected LoggingService loggingService() {
        return ((HazelcastClientInstanceImpl)this.container()).getLoggingService();
    }

    @Override
    protected boolean isRunning() {
        return ((HazelcastClientInstanceImpl)this.container()).getLifecycleService().isRunning();
    }

    @Override
    @Nonnull
    protected UUID doAddStatusListener(@Nonnull JobStatusListener listener) {
        Objects.requireNonNull(listener, "Listener cannot be null");
        try {
            ClientJobStatusEventHandler handler = new ClientJobStatusEventHandler(listener);
            handler.registrationId = ((HazelcastClientInstanceImpl)this.container()).getListenerService().registerListener(this.createJobStatusListenerCodec(this.getId()), handler);
            return handler.registrationId;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t.getCause());
        }
    }

    @Override
    public boolean removeStatusListener(@Nonnull UUID id) {
        return ((HazelcastClientInstanceImpl)this.container()).getListenerService().deregisterListener(id);
    }

    private ListenerMessageCodec createJobStatusListenerCodec(final long jobId) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return JetAddJobStatusListenerCodec.encodeRequest(jobId, (UUID)ClientJobProxy.this.lightJobCoordinator, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return JetAddJobStatusListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID registrationId) {
                return JetRemoveJobStatusListenerCodec.encodeRequest(jobId, registrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return JetRemoveJobStatusListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    private ClientInvocation invocation(ClientMessage request, UUID invocationUuid) {
        return new ClientInvocation((HazelcastClientInstance)this.container(), request, (Object)("jobId=" + this.getIdString()), invocationUuid);
    }

    private <T> T callAndRetryIfTargetNotFound(Callable<T> action) {
        long timeLimit = System.nanoTime() + RETRY_TIME_NS;
        while (true) {
            try {
                return action.call();
            }
            catch (Exception e) {
                if (System.nanoTime() < timeLimit && e instanceof ExecutionException && e.getCause() instanceof TargetNotMemberException) {
                    LockSupport.parkNanos(RETRY_DELAY_NS);
                    continue;
                }
                throw ExceptionUtil.rethrow(e);
            }
            break;
        }
    }

    private class ClientJobStatusEventHandler
    implements EventHandler<ClientMessage> {
        final JetAddJobStatusListenerCodec.AbstractEventHandler handler;
        UUID registrationId;

        ClientJobStatusEventHandler(final JobStatusListener listener) {
            this.handler = new JetAddJobStatusListenerCodec.AbstractEventHandler(){

                @Override
                public void handleJobStatusEvent(long jobId, int previousStatus, int newStatus, @Nullable String description, boolean userRequested) {
                    listener.jobStatusChanged(new JobStatusEvent(jobId, JobStatus.getById(previousStatus), JobStatus.getById(newStatus), description, userRequested));
                    if (JobStatus.getById(newStatus).isTerminal()) {
                        ((ClientListenerServiceImpl)((HazelcastClientInstanceImpl)ClientJobProxy.this.container()).getListenerService()).removeListener(ClientJobStatusEventHandler.this.registrationId);
                    }
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }
}

