/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.client.impl.protocol.codec.JetUploadJobMetaDataCodec;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.submitjob.memberside.JobMetaDataParameterObject;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.io.IOException;
import java.nio.file.Paths;

public class UploadJobMetaDataOperation
extends Operation
implements IdentifiedDataSerializable {
    JobMetaDataParameterObject jobMetaDataParameterObject;

    public UploadJobMetaDataOperation() {
    }

    public UploadJobMetaDataOperation(JetUploadJobMetaDataCodec.RequestParameters parameters) {
        this.jobMetaDataParameterObject = new JobMetaDataParameterObject();
        this.jobMetaDataParameterObject.setSessionId(parameters.sessionId);
        this.jobMetaDataParameterObject.setJarOnMember(parameters.jarOnMember);
        this.jobMetaDataParameterObject.setSha256Hex(parameters.sha256Hex);
        this.jobMetaDataParameterObject.setFileName(parameters.fileName);
        this.jobMetaDataParameterObject.setSnapshotName(parameters.snapshotName);
        this.jobMetaDataParameterObject.setJobName(parameters.jobName);
        this.jobMetaDataParameterObject.setMainClass(parameters.mainClass);
        this.jobMetaDataParameterObject.setJobParameters(parameters.jobParameters);
    }

    @Override
    public void run() {
        if (this.jobMetaDataParameterObject.isJarOnMember()) {
            this.runJarOnMember();
        } else {
            this.runJarOnClient();
        }
    }

    private void runJarOnMember() {
        this.jobMetaDataParameterObject.setJarPath(Paths.get(this.jobMetaDataParameterObject.getFileName(), new String[0]));
        JetServiceBackend jetServiceBackend = this.getJetServiceBackend();
        jetServiceBackend.jarOnMember(this.jobMetaDataParameterObject);
    }

    private void runJarOnClient() {
        NodeEngine nodeEngine = this.getNodeEngine();
        HazelcastProperties hazelcastProperties = nodeEngine.getProperties();
        String uploadDirectoryPath = hazelcastProperties.getString(ClusterProperty.JAR_UPLOAD_DIR_PATH);
        this.jobMetaDataParameterObject.setUploadDirectoryPath(uploadDirectoryPath);
        JetServiceBackend jetServiceBackend = this.getJetServiceBackend();
        jetServiceBackend.jarOnClient(this.jobMetaDataParameterObject);
    }

    protected JetServiceBackend getJetServiceBackend() {
        Util.checkJetIsEnabled(this.getNodeEngine());
        assert (this.getServiceName().equals("hz:impl:jetService")) : "Service is not Jet Service";
        return (JetServiceBackend)this.getService();
    }

    @Override
    public final int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 52;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.jobMetaDataParameterObject.getSessionId());
        out.writeString(this.jobMetaDataParameterObject.getSha256Hex());
        out.writeString(this.jobMetaDataParameterObject.getFileName());
        out.writeString(this.jobMetaDataParameterObject.getSnapshotName());
        out.writeString(this.jobMetaDataParameterObject.getJobName());
        out.writeString(this.jobMetaDataParameterObject.getMainClass());
        SerializationUtil.writeList(this.jobMetaDataParameterObject.getJobParameters(), out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.jobMetaDataParameterObject = new JobMetaDataParameterObject();
        this.jobMetaDataParameterObject.setSessionId(UUIDSerializationUtil.readUUID(in));
        this.jobMetaDataParameterObject.setSha256Hex(in.readString());
        this.jobMetaDataParameterObject.setFileName(in.readString());
        this.jobMetaDataParameterObject.setSnapshotName(in.readString());
        this.jobMetaDataParameterObject.setJobName(in.readString());
        this.jobMetaDataParameterObject.setMainClass(in.readString());
        this.jobMetaDataParameterObject.setJobParameters(SerializationUtil.readList(in));
    }
}

