/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.operation.AbstractMultipleEntryBackupOperation;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.Set;

public class MultipleEntryBackupOperation
extends AbstractMultipleEntryBackupOperation
implements BackupOperation {
    private Set<Data> keys;

    public MultipleEntryBackupOperation() {
    }

    public MultipleEntryBackupOperation(String name, Set<Data> keys, EntryProcessor backupProcessor) {
        super(name, backupProcessor);
        this.keys = keys;
    }

    @Override
    protected void runInternal() {
        EntryOperator operator = EntryOperator.operator(this, this.backupProcessor, this.getPredicate());
        for (Data key : this.keys) {
            operator.operateOnKey(key).doPostOperateOps();
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.backupProcessor = this.callWithNamespaceAwareness(in::readObject);
        int size = in.readInt();
        this.keys = SetUtil.createLinkedHashSet(size);
        for (int i2 = 0; i2 < size; ++i2) {
            Data key = IOUtil.readData(in);
            this.keys.add(key);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.backupProcessor);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            IOUtil.writeData(out, key);
        }
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public int getClassId() {
        return 49;
    }
}

