/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;

public class PutAllBackupOperation
extends MapOperation
implements PartitionAwareOperation,
BackupOperation,
Versioned {
    private boolean disableWanReplicationEvent;
    private List keyValueRecordExpiry;
    @Nullable
    private BitSet noWanReplicationKeys;
    private transient int lastIndex;
    private transient List keyRecordExpiry;

    public PutAllBackupOperation(String name, List keyValueRecordExpiry, @Nullable BitSet noWanReplicationKeys, boolean disableWanReplicationEvent) {
        super(name);
        this.keyValueRecordExpiry = keyValueRecordExpiry;
        this.disableWanReplicationEvent = disableWanReplicationEvent;
        this.noWanReplicationKeys = noWanReplicationKeys;
    }

    public PutAllBackupOperation(String name, List keyValueRecordExpiry, boolean disableWanReplicationEvent) {
        this(name, keyValueRecordExpiry, null, disableWanReplicationEvent);
    }

    public PutAllBackupOperation() {
    }

    @Override
    protected void runInternal() {
        List keyRecordExpiry = this.keyRecordExpiry;
        if (keyRecordExpiry != null) {
            for (int i2 = this.lastIndex; i2 < keyRecordExpiry.size(); i2 += 3) {
                Data key = (Data)keyRecordExpiry.get(i2);
                Record record = (Record)keyRecordExpiry.get(i2 + 1);
                ExpiryMetadata expiryMetadata = (ExpiryMetadata)keyRecordExpiry.get(i2 + 2);
                boolean wanReplicated = this.noWanReplicationKeys == null || !this.noWanReplicationKeys.get(i2 / 3);
                this.putBackup(key, record, expiryMetadata, wanReplicated);
                this.lastIndex = i2;
            }
        } else {
            List keyValueRecordExpiry = this.keyValueRecordExpiry;
            for (int i3 = this.lastIndex; i3 < keyValueRecordExpiry.size(); i3 += 4) {
                Data key = (Data)keyValueRecordExpiry.get(i3);
                Record record = (Record)keyValueRecordExpiry.get(i3 + 2);
                ExpiryMetadata expiryMetadata = (ExpiryMetadata)keyValueRecordExpiry.get(i3 + 3);
                boolean wanReplicated = this.noWanReplicationKeys == null || !this.noWanReplicationKeys.get(i3 / 4);
                this.putBackup(key, record, expiryMetadata, wanReplicated);
                this.lastIndex = i3;
            }
        }
    }

    private void putBackup(Data key, Record record, ExpiryMetadata expiryMetadata, boolean shouldWanReplicate) {
        Object currentRecord = this.recordStore.putBackup(key, record, expiryMetadata.getTtl(), expiryMetadata.getMaxIdle(), expiryMetadata.getExpirationTime(), this.getCallerProvenance());
        Records.copyMetadataFrom(record, currentRecord);
        if (shouldWanReplicate) {
            this.publishWanUpdate(key, record.getValue());
        }
        this.evict(key);
    }

    @Override
    protected boolean disableWanReplicationEvent() {
        return this.disableWanReplicationEvent;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.keyValueRecordExpiry.size() / 4);
        for (int i2 = 0; i2 < this.keyValueRecordExpiry.size(); i2 += 4) {
            Data dataKey = (Data)this.keyValueRecordExpiry.get(i2);
            Data dataValue = (Data)this.keyValueRecordExpiry.get(i2 + 1);
            Record record = (Record)this.keyValueRecordExpiry.get(i2 + 2);
            ExpiryMetadata expiryMetadata = (ExpiryMetadata)this.keyValueRecordExpiry.get(i2 + 3);
            IOUtil.writeData(out, dataKey);
            Records.writeRecord(out, record, dataValue);
            Records.writeExpiry(out, expiryMetadata);
        }
        out.writeBoolean(this.disableWanReplicationEvent);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            if (this.noWanReplicationKeys == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeByteArray(this.noWanReplicationKeys.toByteArray());
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        ArrayList<Object> keyRecordExpiry = new ArrayList<Object>(size * 3);
        for (int i2 = 0; i2 < size; ++i2) {
            Data dataKey = IOUtil.readData(in);
            Record record = Records.readRecord(in);
            ExpiryMetadata expiryMetadata = Records.readExpiry(in);
            keyRecordExpiry.add(dataKey);
            keyRecordExpiry.add(record);
            keyRecordExpiry.add(expiryMetadata);
        }
        this.keyRecordExpiry = keyRecordExpiry;
        this.disableWanReplicationEvent = in.readBoolean();
        this.noWanReplicationKeys = null;
        if (in.getVersion().isGreaterOrEqual(Versions.V5_4) && in.readBoolean()) {
            this.noWanReplicationKeys = BitSet.valueOf(in.readByteArray());
        }
    }

    @Override
    public int getClassId() {
        return 22;
    }
}

