/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.namespace.impl.NodeEngineThreadLocalContext;
import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.SortingUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.IndexAwarePredicate;
import com.hazelcast.query.impl.predicates.VisitablePredicate;
import com.hazelcast.query.impl.predicates.Visitor;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@BinaryInterface
public class PagingPredicateImpl<K, V>
implements PagingPredicate<K, V>,
IndexAwarePredicate<K, V>,
VisitablePredicate,
IdentifiedDataSerializable,
Versioned {
    private static final Map.Entry<Integer, Map.Entry> NULL_ANCHOR = new AbstractMap.SimpleImmutableEntry<Integer, Object>(-1, null);
    private List<Map.Entry<Integer, Map.Entry<K, V>>> anchorList;
    private Predicate<K, V> predicate;
    private Comparator<Map.Entry<K, V>> comparator;
    private int pageSize;
    private int page;
    private IterationType iterationType;
    @Nullable
    private String userCodeNamespace;

    public PagingPredicateImpl() {
    }

    public PagingPredicateImpl(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize must be greater than 0!");
        }
        this.pageSize = pageSize;
        this.anchorList = new ArrayList<Map.Entry<Integer, Map.Entry<K, V>>>();
    }

    public PagingPredicateImpl(Predicate<K, V> predicate, int pageSize) {
        this(pageSize);
        this.setInnerPredicate(predicate);
    }

    public PagingPredicateImpl(Comparator<Map.Entry<K, V>> comparator, int pageSize) {
        this(pageSize);
        this.comparator = comparator;
    }

    public PagingPredicateImpl(Predicate<K, V> predicate, Comparator<Map.Entry<K, V>> comparator, int pageSize) {
        this(pageSize);
        this.setInnerPredicate(predicate);
        this.comparator = comparator;
    }

    @PrivateApi
    public PagingPredicateImpl(List<Map.Entry<Integer, Map.Entry<K, V>>> anchorList, Predicate<K, V> predicate, Comparator<Map.Entry<K, V>> comparator, int pageSize, int page, IterationType iterationType, @Nullable String userCodeNamespace) {
        this.anchorList = anchorList;
        this.predicate = predicate;
        this.comparator = comparator;
        this.pageSize = pageSize;
        this.page = page;
        this.iterationType = iterationType;
        this.userCodeNamespace = userCodeNamespace;
    }

    public PagingPredicateImpl(PagingPredicateImpl<K, V> original) {
        this(original, original.predicate);
    }

    private PagingPredicateImpl(PagingPredicateImpl<K, V> originalPagingPredicate, Predicate<K, V> predicateReplacement) {
        this.anchorList = originalPagingPredicate.anchorList;
        this.comparator = originalPagingPredicate.comparator;
        this.pageSize = originalPagingPredicate.pageSize;
        this.page = originalPagingPredicate.page;
        this.iterationType = originalPagingPredicate.iterationType;
        this.userCodeNamespace = originalPagingPredicate.userCodeNamespace;
        this.setInnerPredicate(predicateReplacement);
    }

    @Override
    public Predicate accept(Visitor visitor, IndexRegistry indexes) {
        Predicate<K, V> predicate = this.predicate;
        if (predicate instanceof VisitablePredicate) {
            VisitablePredicate visitablePredicate = (VisitablePredicate)((Object)predicate);
            return NamespaceUtil.callWithOwnClassLoader(this.predicate, () -> {
                Predicate transformed = visitablePredicate.accept(visitor, indexes);
                return transformed == this.predicate ? this : new PagingPredicateImpl<K, V>(this, transformed);
            });
        }
        return this;
    }

    private void setInnerPredicate(Predicate<K, V> predicate) {
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "Nested PagingPredicate is not supported!");
        this.predicate = predicate;
    }

    @Override
    public Set<QueryableEntry<K, V>> filter(QueryContext queryContext) {
        if (!(this.predicate instanceof IndexAwarePredicate)) {
            return null;
        }
        Set set = NamespaceUtil.callWithNamespace(this.userCodeNamespace, () -> ((IndexAwarePredicate)this.predicate).filter(queryContext));
        if (set == null || set.isEmpty()) {
            return set;
        }
        ArrayList<QueryableEntry> resultList = new ArrayList<QueryableEntry>();
        Map.Entry<Integer, Map.Entry> nearestAnchorEntry = this.getNearestAnchorEntry();
        for (QueryableEntry queryableEntry : set) {
            if (!SortingUtil.compareAnchor(this, queryableEntry, nearestAnchorEntry)) continue;
            resultList.add(queryableEntry);
        }
        List<QueryableEntry> sortedSubList = SortingUtil.getSortedSubList(resultList, this, nearestAnchorEntry);
        return new LinkedHashSet<QueryableEntry<K, V>>(sortedSubList);
    }

    @Override
    public boolean isIndexed(QueryContext queryContext) {
        Predicate<K, V> predicate = this.predicate;
        if (predicate instanceof IndexAwarePredicate) {
            IndexAwarePredicate awarePredicate = (IndexAwarePredicate)predicate;
            return NamespaceUtil.callWithNamespace(this.userCodeNamespace, () -> awarePredicate.isIndexed(queryContext));
        }
        return false;
    }

    @Override
    public boolean apply(Map.Entry mapEntry) {
        if (this.predicate != null) {
            return NamespaceUtil.callWithNamespace(this.userCodeNamespace, () -> this.predicate.apply(mapEntry));
        }
        return true;
    }

    @Override
    public void reset() {
        this.iterationType = null;
        this.anchorList.clear();
        this.page = 0;
    }

    @Override
    public void nextPage() {
        ++this.page;
    }

    @Override
    public void previousPage() {
        if (this.page != 0) {
            --this.page;
        }
    }

    public IterationType getIterationType() {
        return this.iterationType;
    }

    public void setIterationType(IterationType iterationType) {
        this.iterationType = iterationType;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public Predicate<K, V> getPredicate() {
        return this.predicate;
    }

    @Override
    public Comparator<Map.Entry<K, V>> getComparator() {
        return this.comparator;
    }

    @Override
    public Map.Entry<K, V> getAnchor() {
        Map.Entry<Integer, Map.Entry<K, V>> anchorEntry = this.anchorList.get(this.page);
        return anchorEntry == null ? null : anchorEntry.getValue();
    }

    public void setAnchor(int page, Map.Entry anchor) {
        AbstractMap.SimpleImmutableEntry<Integer, Map.Entry> anchorEntry = new AbstractMap.SimpleImmutableEntry<Integer, Map.Entry>(page, anchor);
        int anchorCount = this.anchorList.size();
        if (page < anchorCount) {
            this.anchorList.set(page, anchorEntry);
        } else if (page == anchorCount) {
            this.anchorList.add(anchorEntry);
        } else {
            throw new IllegalArgumentException("Anchor index is not correct, expected: " + page + " found: " + anchorCount);
        }
    }

    public void setAnchorList(List<Map.Entry<Integer, Map.Entry<K, V>>> anchorList) {
        this.anchorList = anchorList;
    }

    public List<Map.Entry<Integer, Map.Entry<K, V>>> getAnchorList() {
        return this.anchorList;
    }

    public String getUserCodeNamespace() {
        return this.userCodeNamespace;
    }

    public Map.Entry<Integer, Map.Entry> getNearestAnchorEntry() {
        int anchorCount = this.anchorList.size();
        if (this.page == 0 || anchorCount == 0) {
            return NULL_ANCHOR;
        }
        Map.Entry<Integer, Map.Entry> anchoredEntry = this.page < anchorCount ? this.anchorList.get(this.page - 1) : this.anchorList.get(anchorCount - 1);
        return anchoredEntry;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            out.writeString(this.userCodeNamespace);
        }
        out.writeObject(this.predicate);
        out.writeObject(this.comparator);
        out.writeInt(this.page);
        out.writeInt(this.pageSize);
        out.writeString(this.iterationType.name());
        out.writeInt(this.anchorList.size());
        for (Map.Entry<Integer, Map.Entry<K, V>> anchor : this.anchorList) {
            out.writeInt(anchor.getKey());
            Map.Entry<K, V> anchorEntry = anchor.getValue();
            out.writeObject(anchorEntry.getKey());
            out.writeObject(anchorEntry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.userCodeNamespace = in.getVersion().isGreaterOrEqual(Versions.V5_4) ? in.readString() : null;
        NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContext();
        NamespaceUtil.setupNamespace(engine, this.userCodeNamespace);
        try {
            this.predicate = (Predicate)in.readObject();
            this.comparator = (Comparator)in.readObject();
        }
        finally {
            NamespaceUtil.cleanupNamespace(engine, this.userCodeNamespace);
        }
        this.page = in.readInt();
        this.pageSize = in.readInt();
        this.iterationType = IterationType.valueOf(in.readString());
        int size = in.readInt();
        this.anchorList = new ArrayList<Map.Entry<Integer, Map.Entry<K, V>>>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            int anchorPage = in.readInt();
            Object anchorKey = in.readObject();
            Object anchorValue = in.readObject();
            AbstractMap.SimpleImmutableEntry anchorEntry = new AbstractMap.SimpleImmutableEntry(anchorKey, anchorValue);
            this.anchorList.add(new AbstractMap.SimpleImmutableEntry(anchorPage, anchorEntry));
        }
    }

    @Override
    public int getFactoryId() {
        return -20;
    }

    @Override
    public int getClassId() {
        return 15;
    }
}

