/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl.xa.operations;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.transaction.impl.TransactionLogRecord;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.transaction.impl.xa.XAService;
import com.hazelcast.transaction.impl.xa.XATransaction;
import com.hazelcast.transaction.impl.xa.operations.AbstractXAOperation;
import com.hazelcast.transaction.impl.xa.operations.PutRemoteTransactionBackupOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class PutRemoteTransactionOperation
extends AbstractXAOperation
implements BackupAwareOperation {
    private final List<TransactionLogRecord> records = new LinkedList<TransactionLogRecord>();
    private SerializableXID xid;
    private UUID txnId;
    private UUID txOwnerUuid;
    private long timeoutMillis;
    private long startTime;

    public PutRemoteTransactionOperation() {
    }

    public PutRemoteTransactionOperation(Collection<TransactionLogRecord> logs, UUID txnId, SerializableXID xid, UUID txOwnerUuid, long timeoutMillis, long startTime) {
        this.records.addAll(logs);
        this.txnId = txnId;
        this.xid = xid;
        this.txOwnerUuid = txOwnerUuid;
        this.timeoutMillis = timeoutMillis;
        this.startTime = startTime;
    }

    @Override
    public void run() throws Exception {
        XAService xaService = (XAService)this.getService();
        NodeEngine nodeEngine = this.getNodeEngine();
        XATransaction transaction = new XATransaction(nodeEngine, this.records, this.txnId, this.xid, this.txOwnerUuid, this.timeoutMillis, this.startTime);
        xaService.putTransaction(transaction);
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return 1;
    }

    @Override
    public Operation getBackupOperation() {
        return new PutRemoteTransactionBackupOperation(this.records, this.txnId, this.xid, this.txOwnerUuid, this.timeoutMillis, this.startTime);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.txnId);
        out.writeObject(this.xid);
        UUIDSerializationUtil.writeUUID(out, this.txOwnerUuid);
        out.writeLong(this.timeoutMillis);
        out.writeLong(this.startTime);
        int len = this.records.size();
        out.writeInt(len);
        if (len > 0) {
            for (TransactionLogRecord record : this.records) {
                out.writeObject(record);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.txnId = UUIDSerializationUtil.readUUID(in);
        this.xid = (SerializableXID)in.readObject();
        this.txOwnerUuid = UUIDSerializationUtil.readUUID(in);
        this.timeoutMillis = in.readLong();
        this.startTime = in.readLong();
        int len = in.readInt();
        if (len > 0) {
            for (int i2 = 0; i2 < len; ++i2) {
                TransactionLogRecord record = (TransactionLogRecord)in.readObject();
                this.records.add(record);
            }
        }
    }

    @Override
    public int getClassId() {
        return 16;
    }
}

