/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.search;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.search.AddressTerm;

public final class RecipientTerm
extends AddressTerm {
    private Message.RecipientType type;
    private static final long serialVersionUID = 6548700653122680468L;

    public RecipientTerm(Message.RecipientType type, Address address) {
        super(address);
        this.type = type;
    }

    public Message.RecipientType getRecipientType() {
        return this.type;
    }

    @Override
    public boolean match(Message msg) {
        Address[] recipients;
        try {
            recipients = msg.getRecipients(this.type);
        }
        catch (Exception e) {
            return false;
        }
        if (recipients == null) {
            return false;
        }
        for (int i2 = 0; i2 < recipients.length; ++i2) {
            if (!super.match(recipients[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RecipientTerm)) {
            return false;
        }
        RecipientTerm rt = (RecipientTerm)obj;
        return rt.type.equals(this.type) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.type.hashCode() + super.hashCode();
    }
}

