/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.asn1.Block;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.encoders.Base64;

public abstract class AbstractBlock
implements Block {
    protected static final String CRLF = "\r\n";

    public static byte[] fromHex(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        byte[] data = new byte[Math.max(0, (len - 3) / 2)];
        for (int i2 = 1; i2 < len - 2; i2 += 2) {
            data[i2 / 2] = (byte)((Character.digit(s.charAt(i2), 16) << 4) + Character.digit(s.charAt(i2 + 1), 16));
        }
        return data;
    }

    public static byte[] fromBase64(String b) {
        return Base64.decode(b);
    }

    public static String toBase64(byte[] b) {
        return new String(Base64.encode(b), StandardCharsets.UTF_8);
    }

    public static String toHex(byte[] data) {
        byte[] bytes = data;
        if (bytes == null) {
            bytes = new byte[]{};
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return "'" + String.valueOf(sb) + "'H";
    }

    public static String toBitString(ASN1BitString bs) {
        if (bs == null) {
            return "''B";
        }
        int i2 = bs.getBytes().length * 8 - bs.getPadBits();
        if (i2 % 8 == 0) {
            return AbstractBlock.toHex(bs.getOctets());
        }
        StringBuilder ret = new StringBuilder();
        ret.append('\'');
        int j = 0;
        int k = 0;
        byte[] b = bs.getBytes();
        while (i2 > 0) {
            int bit = b[j] >> 7 - k & 1;
            ret.append(bit > 0 ? (char)'1' : '0');
            k = (byte)(k + 1);
            if (k > 7) {
                k = 0;
                ++j;
            }
            --i2;
        }
        return ret.append("'B").toString();
    }

    protected void parse(byte[] b) throws IOException {
        this.parse(ASN1Sequence.getInstance(b));
    }

    protected abstract void parse(ASN1Encodable var1) throws IOException;

    protected static byte[] toDer(ASN1Object a) {
        if (a == null) {
            throw new NullPointerException("null object may not be encoded in DER");
        }
        try {
            return a.getEncoded();
        }
        catch (IOException ioe) {
            Logger.getLogger("VortexMessage").log(Level.SEVERE, "Exception while encoding object", ioe);
            return null;
        }
    }

    @Override
    public byte[] toBytes(DumpType dumpType) throws IOException {
        ASN1Object o = this.toAsn1Object(dumpType);
        if (o == null) {
            throw new IOException("Got a null reply from toAsn1Object ... get coding man");
        }
        return AbstractBlock.toDer(o);
    }

    protected String prepareDump(String s) {
        return s.replaceAll("encrypted *'[^']*'H", "encrypted '<encryptedString>'H");
    }
}

