/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import net.messagevortex.asn1.HeaderRequest;
import net.messagevortex.asn1.UsagePeriod;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class HeaderRequestIdentity
extends HeaderRequest
implements Serializable {
    public static final long serialVersionUID = 100000000027L;
    protected UsagePeriod period = null;

    public HeaderRequestIdentity() {
    }

    public HeaderRequestIdentity(ASN1Encodable ae) throws IOException {
        this();
        if (ae != null) {
            this.parse(ae);
        }
    }

    @Override
    protected final void parse(ASN1Encodable ae) throws IOException {
        ASN1Sequence s1 = ASN1Sequence.getInstance(ae);
        this.period = new UsagePeriod(s1.getObjectAt(0));
    }

    @Override
    protected HeaderRequest getRequest(ASN1Encodable ae) throws IOException {
        return new HeaderRequestIdentity(ae);
    }

    public int getId() {
        return 0;
    }

    public UsagePeriod getUsagePeriod() {
        return this.period;
    }

    public UsagePeriod setUsagePeriod(UsagePeriod newPeriod) {
        UsagePeriod old = this.period;
        this.period = newPeriod;
        return old;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        if (this.period != null) {
            sb.append(prefix).append("  period ").append(this.period.dumpValueNotation(prefix + "  ", dumpType)).append("\r\n");
        }
        sb.append(prefix).append('}');
        return sb.toString();
    }

    @Override
    public ASN1Object intToAsn1Object(DumpType dumpType) {
        ASN1EncodableVector s1 = new ASN1EncodableVector();
        s1.add(this.period.toAsn1Object(dumpType));
        return new DERSequence(s1);
    }
}

