/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.IdentityBlock;
import net.messagevortex.asn1.PayloadChunk;
import net.messagevortex.asn1.PrefixBlock;
import net.messagevortex.asn1.RoutingCombo;
import net.messagevortex.asn1.SymmetricKey;
import net.messagevortex.asn1.UsagePeriod;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class InnerMessageBlock
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 100000000009L;
    public static final int PREFIX_PLAIN = 11011;
    public static final int PREFIX_ENCRYPTED = 11012;
    public static final int IDENTITY_PLAIN = 11021;
    public static final int IDENTITY_ENCRYPTED = 11022;
    public static final int ROUTING_PLAIN = 11031;
    public static final int ROUTING_ENCRYPTED = 11032;
    private byte[] padding = new byte[0];
    private PrefixBlock prefix;
    private IdentityBlock identity;
    private byte[] identitySignature = null;
    private RoutingCombo routing;
    private final Object payloadLock = new Object();
    private PayloadChunk[] payload = new PayloadChunk[0];
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());

    public InnerMessageBlock() throws IOException {
        this(new PrefixBlock(), new IdentityBlock(), new RoutingCombo());
    }

    public InnerMessageBlock(Algorithm sym, AsymmetricKey asym) throws IOException {
        this(new PrefixBlock(new SymmetricKey(sym)), new IdentityBlock(asym), new RoutingCombo());
    }

    public InnerMessageBlock(PrefixBlock prefix, IdentityBlock i2, RoutingCombo routing) {
        this.prefix = prefix;
        this.identity = i2;
        this.routing = routing;
    }

    public InnerMessageBlock(byte[] b, AsymmetricKey decryptionKey) throws IOException {
        this.parse(b, decryptionKey);
    }

    protected final void parse(byte[] p, AsymmetricKey decryptionKey) throws IOException {
        try (ASN1InputStream aIn = new ASN1InputStream(p);){
            this.parse(aIn.readObject(), decryptionKey);
            if (this.identity == null) {
                throw new NullPointerException("IdentityBlock may not be null");
            }
        }
    }

    @Override
    protected void parse(ASN1Encodable o) throws IOException {
        this.parse(o, null);
    }

    protected final void parse(ASN1Encodable o, AsymmetricKey decryptionKey) throws IOException {
        byte[] identityEncoded;
        LOGGER.log(Level.FINER, "Executing parse()");
        int i2 = 0;
        ASN1Sequence s1 = ASN1Sequence.getInstance(o);
        this.padding = ASN1OctetString.getInstance(s1.getObjectAt(i2++)).getOctets();
        ASN1TaggedObject ato = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++));
        switch (ato.getTagNo()) {
            case 11011: {
                this.prefix = new PrefixBlock(ato.getBaseObject().toASN1Primitive(), null);
                break;
            }
            case 11012: {
                this.prefix = new PrefixBlock(ASN1OctetString.getInstance(ato.getBaseObject()).getOctets(), decryptionKey);
                break;
            }
            default: {
                throw new IOException("got unexpected tag (expect: 11011 or 11012; got: " + ato.getTagNo() + ")");
            }
        }
        ato = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++));
        switch (ato.getTagNo()) {
            case 11021: {
                identityEncoded = InnerMessageBlock.toDer(ato.getBaseObject());
                this.identity = new IdentityBlock(identityEncoded);
                break;
            }
            case 11022: {
                identityEncoded = ASN1OctetString.getInstance(ato.getBaseObject()).getOctets();
                this.identity = new IdentityBlock(this.prefix.getKey().decrypt(identityEncoded));
                break;
            }
            default: {
                throw new IOException("got unexpected tag (expect: 11011 or 11012; got: " + ato.getTagNo() + ")");
            }
        }
        this.identitySignature = ASN1OctetString.getInstance(s1.getObjectAt(i2++)).getOctets();
        if (!this.identity.getIdentityKey().verify(identityEncoded, this.identitySignature)) {
            throw new IOException("failed verifying signature (signature length:" + this.identitySignature.length + "; signedBlock:" + InnerMessageBlock.toHex(identityEncoded) + ")");
        }
        ASN1TaggedObject ae = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++));
        switch (ae.getTagNo()) {
            case 11031: {
                this.routing = new RoutingCombo(ae.getBaseObject());
                break;
            }
            case 11032: {
                try {
                    this.routing = new RoutingCombo(ASN1Sequence.getInstance(this.prefix.getKey().decrypt(ASN1OctetString.getInstance(ae.getBaseObject()).getOctets())));
                    break;
                }
                catch (IOException ioe) {
                    throw new IOException("error while decrypting router block", ioe);
                }
            }
            default: {
                throw new IOException("got unexpected tag (expect: 11031 or 11032; got: " + ASN1TaggedObject.getInstance(ae).getTagNo() + ")");
            }
        }
        ASN1Sequence seq = ASN1Sequence.getInstance(s1.getObjectAt(i2++));
        ArrayList<PayloadChunk> p2 = new ArrayList<PayloadChunk>(seq.size());
        long creationTime = new Date().getTime();
        long last = this.routing.getLastProcessTime();
        long first = this.routing.getFirstProcessTime();
        for (ASN1Encodable tr : seq) {
            p2.add(new PayloadChunk(tr, new UsagePeriod(new Date(creationTime + last), new Date(creationTime + first))));
        }
        this.payload = p2.toArray(new PayloadChunk[p2.size()]);
    }

    public ASN1Object toAsn1Object() throws IOException {
        return this.toAsn1Object(DumpType.PUBLIC_ONLY);
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        LOGGER.log(Level.FINER, "Executing toAsn1Object()");
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DEROctetString(this.padding));
        switch (dumpType) {
            case INTERNAL: 
            case ALL_UNENCRYPTED: {
                v.add(new DERTaggedObject(11011, this.prefix.toAsn1Object(dumpType)));
                break;
            }
            case ALL: 
            case PUBLIC_ONLY: 
            case PRIVATE_COMMENTED: {
                try {
                    v.add(new DERTaggedObject(11012, new DEROctetString(this.prefix.toEncBytes())));
                    break;
                }
                catch (IOException | NullPointerException e) {
                    throw new IOException("need a decryption key to encrypt prefix block (" + String.valueOf(this.prefix.getDecryptionKey()) + ")", e);
                }
            }
            default: {
                throw new IllegalStateException("unable to handle dump type " + String.valueOf((Object)dumpType));
            }
        }
        if (this.identity == null) {
            throw new IOException("identity may not be null when encoding");
        }
        LOGGER.log(Level.FINER, "adding identity");
        byte[] o = null;
        switch (dumpType) {
            case INTERNAL: 
            case ALL_UNENCRYPTED: {
                ASN1Object t = this.identity.toAsn1Object(dumpType);
                o = InnerMessageBlock.toDer(t);
                v.add(new DERTaggedObject(11021, t));
                break;
            }
            case ALL: 
            case PUBLIC_ONLY: 
            case PRIVATE_COMMENTED: {
                o = this.prefix.getKey().encrypt(this.identity.toBytes(dumpType));
                v.add(new DERTaggedObject(11022, new DEROctetString(o)));
                break;
            }
            default: {
                throw new IllegalStateException("unable to handle dump type " + String.valueOf((Object)dumpType));
            }
        }
        LOGGER.log(Level.FINER, "adding signature");
        if (this.identity.getIdentityKey() == null || !this.identity.getIdentityKey().hasPrivateKey()) {
            throw new IOException("identity needs private key to sign request (" + String.valueOf(this.identity.getIdentityKey()) + ")");
        }
        try {
            v.add(new DEROctetString(this.identity.getIdentityKey().sign(o)));
        }
        catch (IOException ioe) {
            throw new IOException("exception while signing identity", ioe);
        }
        if (this.routing == null) {
            throw new NullPointerException("router may not be null when encoding");
        }
        switch (dumpType) {
            case INTERNAL: 
            case ALL_UNENCRYPTED: {
                v.add(new DERTaggedObject(true, 11031, (ASN1Encodable)this.routing.toAsn1Object(dumpType)));
                break;
            }
            case ALL: 
            case PUBLIC_ONLY: 
            case PRIVATE_COMMENTED: {
                v.add(new DERTaggedObject(true, 11032, (ASN1Encodable)new DEROctetString(this.prefix.getKey().encrypt(InnerMessageBlock.toDer(this.routing.toAsn1Object(dumpType))))));
                break;
            }
            default: {
                throw new IOException("got unknown dump type " + dumpType.name());
            }
        }
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.payload != null && this.payload.length > 0) {
            for (PayloadChunk p : this.payload) {
                v2.add(p.toAsn1Object(dumpType));
            }
        }
        v.add(new DERSequence(v2));
        DERSequence seq = new DERSequence(v);
        LOGGER.log(Level.FINER, "done toAsn1Object()");
        return seq;
    }

    public IdentityBlock getIdentity() {
        return this.identity;
    }

    public RoutingCombo getRouting() {
        return this.routing;
    }

    public PayloadChunk[] getPayload() {
        return (PayloadChunk[])this.payload.clone();
    }

    public PrefixBlock getPrefix() {
        return this.prefix;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dt) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("  {").append("\r\n");
        sb.append(prefix).append("  padding ").append(InnerMessageBlock.toHex(this.padding)).append("\r\n");
        sb.append(prefix).append("  -- Dumping IdentityBlock").append("\r\n");
        sb.append(prefix).append("  identity ");
        switch (dt) {
            case INTERNAL: 
            case ALL_UNENCRYPTED: {
                sb.append("plain ").append(this.identity.dumpValueNotation(prefix + "  ", DumpType.ALL_UNENCRYPTED)).append(',').append("\r\n");
                break;
            }
            case ALL: 
            case PUBLIC_ONLY: 
            case PRIVATE_COMMENTED: {
                sb.append("encrypted ").append(this.identity.dumpValueNotation(prefix + "  ", dt)).append(',').append("\r\n");
                break;
            }
            default: {
                throw new IOException("unable to handle dump type " + String.valueOf((Object)dt));
            }
        }
        sb.append(prefix).append("  router ").append(this.routing.dumpValueNotation(prefix + "  ", dt)).append(',').append("\r\n");
        sb.append(prefix).append("  payload {");
        int i2 = 0;
        if (this.payload != null) {
            for (PayloadChunk p : this.payload) {
                if (i2 > 0) {
                    sb.append(',');
                }
                sb.append("\r\n");
                p.dumpValueNotation(prefix + "  ", dt);
                ++i2;
            }
        }
        sb.append("\r\n");
        sb.append(prefix).append("  }").append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    public RoutingCombo setRouting(RoutingCombo newRouting) {
        RoutingCombo ret = this.routing;
        this.routing = newRouting;
        return ret;
    }

    public byte[] setPayload(int chunkNumber, byte[] payload) {
        this.enlargePayloadSpace(chunkNumber);
        byte[] ret = this.payload[chunkNumber] != null ? this.payload[chunkNumber].getPayload() : null;
        this.payload[chunkNumber] = new PayloadChunk(chunkNumber, payload, null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enlargePayloadSpace(int i2) {
        if (i2 < this.payload.length) {
            return;
        }
        Object object = this.payloadLock;
        synchronized (object) {
            PayloadChunk[] newSpace = new PayloadChunk[i2 + 1];
            int c = 0;
            for (PayloadChunk p : this.payload) {
                newSpace[c++] = p;
            }
            this.payload = newSpace;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        InnerMessageBlock ib = (InnerMessageBlock)o;
        try {
            return Arrays.equals(this.toBytes(DumpType.ALL_UNENCRYPTED), ib.toBytes(DumpType.ALL_UNENCRYPTED));
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.prepareDump(this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED)).hashCode();
        }
        catch (IOException ioe) {
            return -1;
        }
    }
}

