/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router.operation;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.IdentityBlock;
import net.messagevortex.asn1.PayloadChunk;
import net.messagevortex.router.operation.InternalPayloadSpaceStore;
import net.messagevortex.router.operation.Operation;

public class InternalPayloadSpace {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    InternalPayloadSpaceStore payloadSpace;
    IdentityBlock identity;
    final Set<Operation> operations = new HashSet<Operation>();
    final Map<Integer, PayloadChunk> internalPayload = new HashMap<Integer, PayloadChunk>();
    final Map<Integer, PayloadChunk> internalPayloadCache = new ConcurrentHashMap<Integer, PayloadChunk>();
    final Map<Integer, Operation> internalOperationOutput = new HashMap<Integer, Operation>();
    final Map<Integer, Set<Operation>> internalOperationInput = new HashMap<Integer, Set<Operation>>();
    private final long lastcompact = System.currentTimeMillis();

    public InternalPayloadSpace(InternalPayloadSpaceStore payloadSpace, IdentityBlock identity) {
        this.identity = identity;
        this.payloadSpace = payloadSpace;
        this.payloadSpace.setInternalPayload(this.identity, this);
    }

    public IdentityBlock getIdentity() {
        return this.identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PayloadChunk getPayloadCache(int id) {
        Map<Integer, PayloadChunk> map = this.internalPayload;
        synchronized (map) {
            return this.internalPayloadCache.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayloadChunk getPayload(int id) {
        Map<Integer, PayloadChunk> map = this.internalPayload;
        synchronized (map) {
            PayloadChunk pc = this.internalPayload.get(id);
            if (pc != null) {
                return pc;
            }
            pc = this.getPayloadCache(id);
            if (pc != null) {
                return pc;
            }
            Operation op = this.internalOperationOutput.get(id);
            if (op != null && op.canRun()) {
                LOGGER.log(Level.INFO, "executing operation " + String.valueOf(op) + " of identity " + String.valueOf(this.getIdentity()) + " to populate payload id " + id);
                op.execute(new int[]{id});
            }
            return this.getPayloadCache(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayloadChunk setPayload(PayloadChunk p) {
        this.compact();
        Map<Integer, PayloadChunk> map = this.internalPayload;
        synchronized (map) {
            PayloadChunk old = this.getPayload(p.getId());
            if (p.getPayload() == null) {
                this.internalPayload.remove(p.getId());
            } else {
                this.internalPayload.put(p.getId(), p);
            }
            this.invalidateInternalPayloadCache(p.getId());
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateInternalPayloadCache(int id) {
        this.setCalculatedPayload(id, null);
        Set<Operation> set = this.operations;
        synchronized (set) {
            for (Operation op : this.operations) {
                if (Arrays.binarySearch(op.getInputId(), id) < 0) continue;
                for (int i2 : op.getOutputId()) {
                    this.invalidateInternalPayloadCache(i2);
                }
            }
        }
        this.internalPayloadCache.clear();
    }

    public void setCalculatedPayload(int id, PayloadChunk p) {
        this.compact();
        if (p == null) {
            this.internalPayloadCache.remove(id);
        } else {
            this.internalPayloadCache.put(id, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOperation(Operation op) {
        if (op == null || op.getOutputId() == null || op.getOutputId().length == 0) {
            throw new NullPointerException();
        }
        for (int id : op.getOutputId()) {
            if (!this.isCircularDependent(op, id)) continue;
            throw new InvalidParameterException("circular dependency detected on id " + id);
        }
        for (int id : op.getOutputId()) {
            if (Arrays.binarySearch(op.getInputId(), id) <= -1) continue;
            throw new InvalidParameterException("circular dependency detected between the in and outputs of this function on id " + id);
        }
        Set<Operation> set = this.operations;
        synchronized (set) {
            op.setInternalPayload(this);
            int[] id = op.getOutputId();
            for (int i2 = 0; i2 < id.length; ++i2) {
                this.internalOperationOutput.put(id[i2], op);
            }
            id = op.getInputId();
            Map<Integer, Set<Operation>> map = this.internalOperationInput;
            synchronized (map) {
                for (int i3 = 0; i3 < id.length; ++i3) {
                    Set<Operation> l = this.internalOperationInput.get(id[i3]);
                    if (l == null) {
                        l = new HashSet<Operation>();
                        this.internalOperationInput.put(id[i3], l);
                    }
                    l.add(op);
                }
            }
            this.operations.add(op);
        }
    }

    private boolean isCircularDependent(Operation op, int id) {
        Operation top = this.internalOperationOutput.get(id);
        if (top == null) {
            return false;
        }
        for (int tid : top.getInputId()) {
            if (Arrays.binarySearch(op.getOutputId(), tid) >= 0) {
                return true;
            }
            if (!this.isCircularDependent(op, tid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterOperation(Operation op) {
        if (op == null || op.getOutputId() == null) {
            throw new NullPointerException();
        }
        Set<Operation> set = this.operations;
        synchronized (set) {
            op.setInternalPayload(null);
            int[] id = op.getOutputId();
            for (int i2 = 0; i2 < id.length; ++i2) {
                this.internalOperationOutput.remove(id[i2]);
                this.setCalculatedPayload(id[i2], null);
            }
            id = op.getInputId();
            Map<Integer, Set<Operation>> map = this.internalOperationInput;
            synchronized (map) {
                for (int i3 = 0; i3 < id.length; ++i3) {
                    Set<Operation> l = this.internalOperationInput.get(id[i3]);
                    if (l == null || !l.isEmpty()) continue;
                    l.remove(op);
                    if (!l.isEmpty()) continue;
                    this.internalOperationInput.remove(id[i3]);
                }
            }
            this.operations.remove(op);
        }
    }

    public boolean addOperation(Operation op) {
        this.compact();
        for (int id : op.getOutputId()) {
            if (this.internalOperationOutput.get(id) == null) continue;
            LOGGER.log(Level.WARNING, "addin of operation " + String.valueOf(op) + " due to conflicting outputs (conflicting op is:" + String.valueOf(this.internalOperationOutput.get(id)) + ")");
            return false;
        }
        this.registerOperation(op);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOperation(Operation op) {
        Set<Operation> set = this.operations;
        synchronized (set) {
            if (!this.operations.contains(op)) {
                return false;
            }
            this.deregisterOperation(op);
            this.compact();
        }
        return true;
    }

    protected boolean compact() {
        if (System.currentTimeMillis() < this.lastcompact + 10000L) {
            return false;
        }
        this.compactExpiredOperations();
        this.compactExpiredPayloads();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactExpiredOperations() {
        Set<Operation> set = this.operations;
        synchronized (set) {
            ArrayList<Operation> ops = new ArrayList<Operation>();
            for (Operation op : this.operations) {
                if (op.isInUsagePeriod()) continue;
                ops.add(op);
            }
            for (Operation op : ops) {
                LOGGER.log(Level.INFO, "clearing expired operation " + String.valueOf(op) + " of identity " + String.valueOf(this.getIdentity()));
                this.deregisterOperation(op);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactExpiredPayloads() {
        Map<Integer, PayloadChunk> map = this.internalPayload;
        synchronized (map) {
            ArrayList<Integer> expiredPayloadIds = new ArrayList<Integer>();
            for (Map.Entry<Integer, PayloadChunk> pce : this.internalPayload.entrySet()) {
                if (pce.getValue().isInUsagePeriod()) continue;
                expiredPayloadIds.add(pce.getKey());
            }
            Object object = expiredPayloadIds.iterator();
            while (object.hasNext()) {
                int i2 = (Integer)((Object)object.next());
                LOGGER.log(Level.INFO, "clearing expired payload " + i2 + " of identity " + String.valueOf(this.getIdentity()));
                this.setPayload(new PayloadChunk(i2, null, null));
            }
            object = this.internalOperationInput;
            synchronized (object) {
                Iterator iterator = expiredPayloadIds.iterator();
                while (iterator.hasNext()) {
                    int i3 = (Integer)iterator.next();
                    Set<Operation> ops = this.internalOperationInput.get(i3);
                    if (ops == null || ops.isEmpty()) continue;
                    for (Operation op : ops) {
                        for (int j : op.getOutputId()) {
                            this.setCalculatedPayload(j, null);
                        }
                    }
                }
            }
        }
    }
}

