/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.imap.ImapBlankLineException;
import net.messagevortex.transport.imap.ImapConnection;
import net.messagevortex.transport.imap.ImapException;
import net.messagevortex.transport.imap.ImapNullLineException;

public class ImapLine {
    private static final int MAX_CONTEXT = 30;
    private static final String ABNF_SP = " ";
    private static final String ABNF_CTL = ImapLine.charlistBuilder(0, 31);
    private static final String ABNF_LIST_WILDCARDS = "*%";
    private static final String ABNF_QUOTED_SPECIALS = "\"\\";
    private static final String ABNF_RESP_SPECIALS = "[";
    private static final String ABNF_ATOM_SPECIALS = "(){ " + ABNF_CTL + "*%\"\\[";
    private static final String ABNF_ATOM_CHAR = ImapLine.charlistDifferencer(ImapLine.charlistBuilder(1, 127), ABNF_ATOM_SPECIALS);
    private static final String ABNF_TEXT_CHAR = ImapLine.charlistDifferencer(ImapLine.charlistBuilder(1, 127), "\r\n");
    private static final String ABNF_QUOTED_CHAR = ImapLine.charlistDifferencer(ABNF_TEXT_CHAR, "\"\\");
    private static final String ABNF_TAG = ImapLine.charlistDifferencer(ABNF_ATOM_CHAR, "+");
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static final Object TAG_ENUMERATOR_LOCK = new Object();
    private static int tagEnumerator = 0;
    private String context = "";
    private final ImapConnection con;
    private String commandToken = null;
    private String tagToken = null;
    private InputStream input = null;
    private String buffer = "";

    public ImapLine(ImapConnection con, String line, InputStream input) throws ImapException {
        this.con = con;
        this.input = input;
        this.buffer = line;
        if (this.buffer == null && this.input == null) {
            throw new ImapNullLineException(this);
        }
        if (this.input == null) {
            this.input = new ByteArrayInputStream("".getBytes(Charset.defaultCharset()));
        }
        this.prepareStorage(con, line, input);
        this.checkEmptyLine();
        this.prefillCommandFields();
        if ("BAD".equalsIgnoreCase(this.commandToken) || "OK".equalsIgnoreCase(this.commandToken) || "*".equals(this.tagToken)) {
            LOGGER.log(Level.INFO, "Parsing command " + this.tagToken + ABNF_SP + this.commandToken);
        }
        this.skipWhitespace(-1);
    }

    public ImapLine(ImapConnection con, String line) throws ImapException {
        this(con, line, null);
    }

    public static String charlistBuilder(int start, int end) {
        if (start < 0 || start > 255) {
            return null;
        }
        if (end < 0 || end > 255) {
            return null;
        }
        if (end < start) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int i2 = start; i2 <= end; ++i2) {
            ret.append((char)i2);
        }
        return ret.toString();
    }

    public static String charlistDifferencer(String superset, String subset) {
        String ret = superset;
        for (int i2 = 0; i2 < subset.length(); ++i2) {
            char c = subset.charAt(i2);
            ret = ret.replace("" + c, "");
        }
        return ret;
    }

    public static String commandEncoder(String command) {
        if (command == null) {
            return "<null>";
        }
        return command.replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");
    }

    public static String getNextTag() {
        return ImapLine.getNextTag("A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNextTag(String prefix) {
        String ret;
        Object object = TAG_ENUMERATOR_LOCK;
        synchronized (object) {
            ret = prefix + String.format("%d", ++tagEnumerator);
        }
        return ret;
    }

    private void prepareStorage(ImapConnection con, String line, InputStream input) throws ImapException {
        if (this.buffer == null) {
            this.buffer = "";
            if (this.snoopBytes(1L) == null) {
                throw new ImapBlankLineException(this);
            }
        }
    }

    private void checkEmptyLine() throws ImapException {
        if ("\r\n".equals(this.snoopBytes(2L)) || "".equals(this.snoopBytes(1L)) || this.snoopBytes(1L) == null) {
            if ("\r\n".equals(this.snoopBytes(2L))) {
                this.skipUntilLineEnd();
                throw new ImapBlankLineException(this);
            }
            throw new ImapNullLineException(this);
        }
    }

    private void prefillCommandFields() throws ImapException {
        this.tagToken = this.getATag();
        if (this.tagToken == null || "".equals(this.tagToken)) {
            this.skipUntilLineEnd();
            throw new ImapException(this, "error getting tag");
        }
        int i2 = this.skipWhitespace(1);
        if (i2 != 1) {
            throw new ImapException(this, "error skipping to command (line=\"" + this.context + "\"; tag=" + this.tagToken + "; buffer=" + this.buffer + "; skipped=" + i2 + ")");
        }
        this.commandToken = this.getATag();
        if (this.commandToken == null || "".equals(this.commandToken)) {
            this.skipUntilLineEnd();
            throw new ImapException(this, "error getting command");
        }
    }

    public ImapConnection getConnection() {
        return this.con;
    }

    public String getCommand() {
        return this.commandToken;
    }

    public String getTag() {
        return this.tagToken;
    }

    private boolean readBuffer(long num) {
        boolean ended = false;
        try {
            while ((long)this.buffer.length() < num && !ended) {
                int i2 = this.input.read();
                if (i2 >= 0) {
                    this.buffer = this.buffer + (char)i2;
                    continue;
                }
                ended = true;
            }
        }
        catch (IOException ioe) {
            ended = true;
            LOGGER.log(Level.FINER, "IO exception raised while reading into buffer (" + String.valueOf(ioe) + ")");
        }
        return ended;
    }

    public boolean snoopEscQuotes() {
        return "\\".contains(this.snoopBytes(1L)) && this.snoopBytes(2L).length() == 2 && ABNF_QUOTED_SPECIALS.contains(this.snoopBytes(2L).substring(1, 2));
    }

    public String snoopBytes(long num) {
        if (num <= 0L) {
            return null;
        }
        this.readBuffer(num);
        if (this.buffer.length() == 0) {
            return null;
        }
        if ((long)this.buffer.length() < num) {
            return this.buffer;
        }
        return this.buffer.substring(0, (int)num);
    }

    private void addContext(String chunk) {
        this.context = this.context + chunk;
        if (this.context.length() > 30) {
            this.context = this.context.substring(this.context.length() - 30);
        }
    }

    public String getContext() {
        return this.context + "^^^" + this.buffer;
    }

    public String skipBytes(long num) {
        return this.skipBytes(num, true);
    }

    public String skipBytes(long num, boolean modContext) {
        this.readBuffer(num);
        if ((long)this.buffer.length() < num) {
            this.buffer = "";
            if (modContext) {
                this.addContext(this.buffer);
            }
            return this.buffer;
        }
        String ret = this.snoopBytes(num);
        if (modContext) {
            this.addContext(ret);
        }
        this.buffer = this.buffer.substring((int)num);
        return ret;
    }

    public final int skipWhitespace(int num) {
        int count = 0;
        LOGGER.log(Level.FINER, "Skipping " + num + " spaces");
        for (int countdown = num; countdown != 0 && this.snoopBytes(1L) != null && ABNF_SP.contains(this.snoopBytes(1L)); --countdown) {
            this.skipBytes(1L);
            ++count;
        }
        LOGGER.log(Level.FINER, "Skipped " + count + " spaces");
        return count;
    }

    public boolean skipLineEnd() {
        LOGGER.log(Level.FINER, "Skipping CRLF");
        if (this.snoopBytes(2L) != null && "\r\n".equals(this.snoopBytes(2L))) {
            this.skipBytes(2L);
            LOGGER.log(Level.FINER, "CRLF skipped");
            return true;
        }
        LOGGER.log(Level.FINER, "no CRLF found");
        return false;
    }

    public boolean skipUntilLineEnd() {
        while (this.snoopBytes(2L) != null && !"\r\n".equals(this.snoopBytes(2L))) {
            this.skipBytes(1L, false);
        }
        if (this.snoopBytes(2L) != null && "\r\n".equals(this.snoopBytes(2L))) {
            this.skipBytes(2L, false);
            return true;
        }
        return false;
    }

    private long getLengthPrefix() {
        this.skipBytes(1L);
        long num = 0L;
        while (num < 0xFFFFFFFFL && this.snoopBytes(1L) != null && "0123456789".contains(this.snoopBytes(1L))) {
            num = num * 10L + (long)this.skipBytes(1L).charAt(0) - (long)"0".charAt(0);
        }
        return num;
    }

    private String getLengthPrefixedString() {
        long num = this.getLengthPrefix();
        if (num < 0L || num > 0xFFFFFFFFL) {
            return null;
        }
        String ret = this.skipBytes(1L);
        if (!"}".equals(ret)) {
            return null;
        }
        this.skipLineEnd();
        ret = this.skipBytes(num);
        if (ret == null || (long)ret.length() < num) {
            return null;
        }
        return ret;
    }

    private String getQuotedString() {
        this.skipBytes(1L);
        StringBuilder ret = new StringBuilder();
        while (this.snoopBytes(1L) != null && (ABNF_QUOTED_CHAR.contains(this.snoopBytes(1L)) || this.snoopEscQuotes())) {
            if ("\\".contains(this.snoopBytes(1L))) {
                ret.append(this.skipBytes(2L).charAt(1));
                continue;
            }
            ret.append(this.skipBytes(1L));
        }
        if (this.snoopBytes(1L) == null || !"\"".equals(this.skipBytes(1L))) {
            return null;
        }
        return ret.toString();
    }

    public String getString() {
        String start = this.snoopBytes(1L);
        String ret = null;
        if ("{".equals(start)) {
            return this.getLengthPrefixedString();
        }
        if ("\"".equals(start)) {
            return this.getQuotedString();
        }
        return ret;
    }

    public String getAString() {
        String start = this.snoopBytes(1L);
        Object ret = null;
        if ("{".equals(start) || "\"".equals(start)) {
            ret = this.getString();
        } else {
            while (this.snoopBytes(1L) != null && ABNF_ATOM_CHAR.contains(this.snoopBytes(1L))) {
                if (ret == null) {
                    ret = "";
                }
                ret = (String)ret + this.skipBytes(1L);
            }
        }
        return ret;
    }

    public String getATag() {
        Object ret = null;
        while (this.snoopBytes(1L) != null && ABNF_TAG.contains(this.snoopBytes(1L))) {
            if (ret == null) {
                ret = "";
            }
            ret = (String)ret + this.skipBytes(1L);
        }
        if ("".equals(ret)) {
            return null;
        }
        return ret;
    }
}

