/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.plugins;

import java.util.Properties;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.plugins.Declaration;
import org.apache.commons.digester3.plugins.PluginException;
import org.apache.commons.digester3.plugins.PluginInvalidInputException;
import org.apache.commons.digester3.plugins.PluginManager;
import org.apache.commons.digester3.plugins.PluginRules;
import org.xml.sax.Attributes;

public class PluginDeclarationRule
extends Rule {
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        int nAttrs = attributes.getLength();
        Properties props = new Properties();
        for (int i2 = 0; i2 < nAttrs; ++i2) {
            String key = attributes.getLocalName(i2);
            if (key == null || key.length() == 0) {
                key = attributes.getQName(i2);
            }
            String value = attributes.getValue(i2);
            props.setProperty(key, value);
        }
        try {
            PluginDeclarationRule.declarePlugin(this.getDigester(), props);
        }
        catch (PluginInvalidInputException ex) {
            throw new PluginInvalidInputException("Error on element [" + this.getDigester().getMatch() + "]: " + ex.getMessage());
        }
    }

    public static void declarePlugin(Digester digester, Properties props) throws PluginException {
        String id = props.getProperty("id");
        String pluginClassName = props.getProperty("class");
        if (id == null) {
            throw new PluginInvalidInputException("mandatory attribute id not present on plugin declaration");
        }
        if (pluginClassName == null) {
            throw new PluginInvalidInputException("mandatory attribute class not present on plugin declaration");
        }
        Declaration newDecl = new Declaration(pluginClassName);
        newDecl.setId(id);
        newDecl.setProperties(props);
        PluginRules rc = (PluginRules)digester.getRules();
        PluginManager pm = rc.getPluginManager();
        newDecl.init(digester, pm);
        pm.addDeclaration(newDecl);
    }
}

