/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.dependencies.Dependencies;
import org.apache.maven.report.projectinfo.dependencies.DependenciesReportConfiguration;
import org.apache.maven.report.projectinfo.dependencies.RepositoryUtils;
import org.apache.maven.report.projectinfo.dependencies.renderer.DependenciesRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.jar.classes.JarClassesAnalysis;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="dependencies", requiresDependencyResolution=ResolutionScope.TEST)
public class DependenciesReport
extends AbstractProjectInfoReport {
    private static final String RESOURCES_DIR = "org/apache/maven/report/projectinfo/resources";
    @Parameter(property="dependency.details.enabled", defaultValue="true")
    private boolean dependencyDetailsEnabled;
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final JarClassesAnalysis classesAnalyzer;
    private final RepositoryUtils repoUtils;

    @Inject
    protected DependenciesReport(RepositorySystem repositorySystem, I18N i18n, ProjectBuilder projectBuilder, @Named(value="default") DependencyGraphBuilder dependencyGraphBuilder, JarClassesAnalysis classesAnalyzer, RepositoryUtils repoUtils) {
        super(repositorySystem, i18n, projectBuilder);
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.classesAnalyzer = classesAnalyzer;
        this.repoUtils = repoUtils;
    }

    @Override
    public boolean canGenerateReport() throws MavenReportException {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            DependencyNode dependencyNode = this.resolveProject();
            Dependencies dependencies = new Dependencies(this.project, dependencyNode, this.classesAnalyzer);
            result = dependencies.hasDependencies();
        }
        return result;
    }

    @Override
    public void executeReport(Locale locale) {
        try {
            this.copyResources(this.getReportOutputDirectory());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot copy resources", (Throwable)e);
        }
        DependencyNode dependencyNode = this.resolveProject();
        Dependencies dependencies = new Dependencies(this.project, dependencyNode, this.classesAnalyzer);
        DependenciesReportConfiguration config = new DependenciesReportConfiguration(this.dependencyDetailsEnabled);
        DependenciesRenderer r = new DependenciesRenderer(this.getSink(), locale, this.getI18N(locale), this.getLog(), dependencies, dependencyNode, config, this.repoUtils, this.getLicenseMappings());
        r.render();
    }

    @Override
    public String getOutputName() {
        return "dependencies";
    }

    @Override
    protected String getI18Nsection() {
        return "dependencies";
    }

    private DependencyNode resolveProject() {
        try {
            ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("test");
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getSession().getProjectBuildingRequest());
            buildingRequest.setProject(this.project);
            return this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, (ArtifactFilter)artifactFilter);
        }
        catch (DependencyGraphBuilderException e) {
            this.getLog().error((CharSequence)"Unable to build dependency tree.", (Throwable)e);
            return null;
        }
    }

    private void copyResources(File outputDirectory) throws IOException {
        InputStream resourceList = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/report/projectinfo/resources/resources.txt");
        if (resourceList != null) {
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(resourceList, StandardCharsets.US_ASCII));){
                String line = ((BufferedReader)reader).readLine();
                while (line != null) {
                    try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/report/projectinfo/resources/" + line);){
                        if (in == null) {
                            throw new IOException("The resource " + line + " doesn't exist.");
                        }
                        File outputFile = new File(outputDirectory, line);
                        if (!outputFile.getParentFile().exists()) {
                            outputFile.getParentFile().mkdirs();
                        }
                        try (FileOutputStream out = new FileOutputStream(outputFile);){
                            IOUtil.copy(in, (OutputStream)out);
                        }
                    }
                    line = ((BufferedReader)reader).readLine();
                }
            }
        }
    }
}

