/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.command.add.HgAddCommand;
import org.apache.maven.scm.provider.hg.command.blame.HgBlameCommand;
import org.apache.maven.scm.provider.hg.command.branch.HgBranchCommand;
import org.apache.maven.scm.provider.hg.command.changelog.HgChangeLogCommand;
import org.apache.maven.scm.provider.hg.command.checkin.HgCheckInCommand;
import org.apache.maven.scm.provider.hg.command.checkout.HgCheckOutCommand;
import org.apache.maven.scm.provider.hg.command.diff.HgDiffCommand;
import org.apache.maven.scm.provider.hg.command.info.HgInfoCommand;
import org.apache.maven.scm.provider.hg.command.inventory.HgListCommand;
import org.apache.maven.scm.provider.hg.command.remove.HgRemoveCommand;
import org.apache.maven.scm.provider.hg.command.status.HgStatusCommand;
import org.apache.maven.scm.provider.hg.command.tag.HgTagCommand;
import org.apache.maven.scm.provider.hg.command.update.HgUpdateCommand;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;

@Singleton
@Named(value="hg")
public class HgScmProvider
extends AbstractScmProvider {
    @Override
    public String getScmSpecificFilename() {
        return ".hg";
    }

    @Override
    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        HgUrlParserResult result = this.parseScmUrl(scmSpecificUrl);
        if (result.messages.size() > 0) {
            throw new ScmRepositoryException("The scm url is invalid.", result.messages);
        }
        return result.repository;
    }

    private HgUrlParserResult parseScmUrl(String scmSpecificUrl) {
        HgUrlParserResult result = new HgUrlParserResult();
        if (scmSpecificUrl.startsWith("file")) {
            if (!scmSpecificUrl.startsWith("file:///") && !scmSpecificUrl.startsWith("file://localhost/")) {
                result.messages.add("An hg 'file' url must be on the form 'file:///' or 'file://localhost/'.");
                return result;
            }
        } else if (scmSpecificUrl.startsWith("https")) {
            if (!scmSpecificUrl.startsWith("https://")) {
                result.messages.add("An hg 'http' url must be on the form 'https://'.");
                return result;
            }
        } else if (scmSpecificUrl.startsWith("http")) {
            if (!scmSpecificUrl.startsWith("http://")) {
                result.messages.add("An hg 'http' url must be on the form 'http://'.");
                return result;
            }
        } else {
            try {
                File file = new File(scmSpecificUrl);
            }
            catch (Throwable e) {
                result.messages.add("The filename provided is not valid");
                return result;
            }
        }
        result.repository = new HgScmProviderRepository(scmSpecificUrl);
        return result;
    }

    @Override
    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        if (path == null) {
            throw new NullPointerException("Path argument is null");
        }
        if (!path.isDirectory()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a valid directory.");
        }
        File hgDir = new File(path, ".hg");
        if (!hgDir.exists()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a hg directory.");
        }
        return this.makeProviderScmRepository(path.getAbsolutePath(), ':');
    }

    @Override
    public List<String> validateScmUrl(String scmSpecificUrl, char delimiter) {
        HgUrlParserResult result = this.parseScmUrl(scmSpecificUrl);
        return result.messages;
    }

    @Override
    public String getScmType() {
        return "hg";
    }

    @Override
    public AddScmResult add(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgAddCommand command = new HgAddCommand();
        return (AddScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    public ChangeLogScmResult changelog(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgChangeLogCommand command = new HgChangeLogCommand();
        return (ChangeLogScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    public CheckInScmResult checkin(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgCheckInCommand command = new HgCheckInCommand();
        return (CheckInScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    public CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgCheckOutCommand command = new HgCheckOutCommand();
        return (CheckOutScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    public TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgTagCommand command = new HgTagCommand();
        return (TagScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    public DiffScmResult diff(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgDiffCommand command = new HgDiffCommand();
        return (DiffScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    public RemoveScmResult remove(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgRemoveCommand command = new HgRemoveCommand();
        return (RemoveScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    public StatusScmResult status(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgStatusCommand command = new HgStatusCommand();
        return (StatusScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    public UpdateScmResult update(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgUpdateCommand command = new HgUpdateCommand();
        return (UpdateScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    protected BlameScmResult blame(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgBlameCommand command = new HgBlameCommand();
        return (BlameScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    public BranchScmResult branch(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgBranchCommand command = new HgBranchCommand();
        return (BranchScmResult)command.execute(repository, fileSet, parameters);
    }

    @Override
    protected ListScmResult list(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgListCommand hgListCommand = new HgListCommand();
        return (ListScmResult)hgListCommand.executeCommand(repository, fileSet, parameters);
    }

    @Override
    public InfoScmResult info(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgInfoCommand infoCommand = new HgInfoCommand();
        return (InfoScmResult)infoCommand.execute(repository, fileSet, parameters);
    }

    private static class HgUrlParserResult {
        private final List<String> messages = new ArrayList<String>();
        private ScmProviderRepository repository;

        private HgUrlParserResult() {
        }
    }
}

